/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.adapter.internal.AdapterManagerImpl;
import org.apache.sling.adapter.internal.MockComponentContext;
import org.apache.sling.adapter.internal.MockServiceReference;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.testing.osgi.MockBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class AdapterManagerTestHelper {
    private static AdapterManagerImpl adapterMgr;
    private static MockComponentContext mockContext;
    private static List<ServiceReference> registeredFactories;

    private static void initAdapterManager() {
        if (adapterMgr == null) {
            adapterMgr = new AdapterManagerImpl();
            mockContext = new MockComponentContext();
            adapterMgr.activate((ComponentContext)mockContext);
        }
    }

    public static void registerAdapterFactory(AdapterFactory adapterFactory, String[] adaptableClasses, String[] adapterClasses) {
        AdapterManagerTestHelper.registerAdapterFactory(1L, 1L, adapterFactory, adaptableClasses, adapterClasses);
    }

    public static void registerAdapterFactory(long bundleId, long serviceId, AdapterFactory adapterFactory, String[] adaptableClasses, String[] adapterClasses) {
        AdapterManagerTestHelper.initAdapterManager();
        MockBundle bundle = new MockBundle(bundleId);
        MockServiceReference ref = new MockServiceReference((Bundle)bundle);
        mockContext.addService(ref, adapterFactory);
        ref.setProperty("service.id", serviceId);
        ref.setProperty("adaptables", adaptableClasses);
        ref.setProperty("adapters", adapterClasses);
        adapterMgr.bindAdapterFactory((ServiceReference)ref);
        registeredFactories.add(ref);
    }

    public static void resetAdapterFactories() {
        if (adapterMgr != null) {
            for (ServiceReference ref : registeredFactories) {
                adapterMgr.unbindAdapterFactory(ref);
            }
        }
    }

    static {
        registeredFactories = new ArrayList<ServiceReference>();
    }
}

