/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget;

import com.day.cq.commons.LabeledResource;
import com.day.cq.commons.TidyJSONWriter;
import com.day.text.Text;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtTreeJsonWriter {
    private final ResourceResolver resolver;
    private final Predicate predicate;
    private final int depth;
    private boolean tidy;

    public ExtTreeJsonWriter(ResourceResolver resolver, Predicate predicate, int depth) {
        this.resolver = resolver;
        this.predicate = predicate;
        this.depth = depth;
    }

    public boolean isTidy() {
        return this.tidy;
    }

    public void setTidy(boolean tidy) {
        this.tidy = tidy;
    }

    public void write(Writer out, String path) throws IOException {
        this.write(out, this.resolver.getResource(path));
    }

    public void write(Writer out, Resource res) throws IOException {
        try {
            TidyJSONWriter jw = new TidyJSONWriter(out);
            jw.setTidy(this.tidy);
            if (res == null) {
                jw.array();
                jw.endArray();
                return;
            }
            boolean isOrderable = this.getIsOrderable(res);
            this.write((JSONWriter)jw, this.getChildren(res), 0, isOrderable);
        }
        catch (JSONException e) {
            throw new IOException("Error while writing json " + (Object)((Object)e));
        }
    }

    private void write(JSONWriter out, List<Resource> list, int level, boolean orderable) throws JSONException {
        out.array();
        List<Resource> oList = orderable ? list : this.orderList(list);
        for (Resource resource : oList) {
            String text;
            out.object();
            LabeledResource lr = (LabeledResource)resource.adaptTo(LabeledResource.class);
            String name = Text.getName((String)resource.getPath());
            out.key("name").value((Object)name);
            if (lr == null) {
                text = name;
            } else {
                String string = text = lr.getTitle() == null ? name : lr.getTitle();
                if (lr.getDescription() != null) {
                    out.key("description").value((Object)lr.getDescription());
                }
            }
            if (text != null) {
                text = text.replaceAll("<", "&lt;");
            }
            out.key("text").value((Object)text);
            out.key("type").value((Object)resource.getResourceType());
            List<Resource> children = this.getChildren(resource);
            out.key("cls").value((Object)(children.isEmpty() ? "file" : "folder"));
            if (children.isEmpty()) {
                out.key("leaf").value(true);
            } else if (level < this.depth) {
                out.key("children");
                boolean isOrderable = this.getIsOrderable(resource);
                this.write(out, children, level + 1, isOrderable);
            }
            out.endObject();
        }
        out.endArray();
    }

    private List<Resource> getChildren(Resource res) {
        LinkedList<Resource> children = new LinkedList<Resource>();
        Iterator iter = this.resolver.listChildren(res);
        while (iter.hasNext()) {
            Resource child = (Resource)iter.next();
            if (this.predicate != null && !this.predicate.evaluate((Object)child)) continue;
            children.add(child);
        }
        return children;
    }

    private List<Resource> orderList(List<Resource> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Resource r1 = (Resource)o1;
                Resource r2 = (Resource)o2;
                return Text.getName((String)r1.getPath()).compareToIgnoreCase(Text.getName((String)r2.getPath()));
            }
        });
        return list;
    }

    private boolean getIsOrderable(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.getPrimaryNodeType().hasOrderableChildNodes();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }
}

