/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget.servlets;

import com.day.cq.commons.SlingRepositoryException;
import com.day.image.Layer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractImageServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.checkModifiedSince(request, response)) {
                return;
            }
            String type = this.getImageType(request.getRequestPathInfo().getExtension());
            if (type == null) {
                response.sendError(404, "Image type not supported");
                return;
            }
            ImageContext context = new ImageContext(request, type);
            Layer layer = this.createLayer(context);
            if (layer == null) {
                response.sendError(404);
                return;
            }
            this.writeLayer(request, response, context, layer);
        }
        catch (RepositoryException e) {
            throw new SlingRepositoryException(e);
        }
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, ImageContext context, Layer layer) throws IOException, RepositoryException {
        response.setContentType(context.requestImageType);
        int size = layer.getHeight() * layer.getWidth();
        if (size < 0x100000) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            layer.write(context.requestImageType, this.getImageQuality(), (OutputStream)out);
            byte[] bytes = out.toByteArray();
            response.setContentLength(bytes.length);
            response.getOutputStream().write(bytes);
        } else {
            layer.write(context.requestImageType, this.getImageQuality(), (OutputStream)response.getOutputStream());
        }
    }

    protected String getImageType(String ext) {
        if ("png".equals(ext)) {
            return "image/png";
        }
        if ("gif".equals(ext)) {
            return "image/gif";
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return "image/jpeg";
        }
        return null;
    }

    protected double getImageQuality() {
        return 1.0;
    }

    protected boolean checkModifiedSince(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        Node node = (Node)req.getResource().adaptTo(Node.class);
        Calendar lastMod = null;
        try {
            while (node.getDepth() > 0 && lastMod == null) {
                if (node.hasProperty("jcr:lastModified")) {
                    lastMod = node.getProperty("jcr:lastModified").getDate();
                    continue;
                }
                if (node.hasProperty("cq:lastModified")) {
                    lastMod = node.getProperty("cq:lastModified").getDate();
                    continue;
                }
                node = node.getParent();
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while searching for last modified property: " + (Object)((Object)e));
            return false;
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("If-Modified-Since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod.getTimeInMillis());
        }
        return false;
    }

    protected abstract Layer createLayer(ImageContext var1) throws RepositoryException, IOException;

    public static class ImageContext {
        public final SlingHttpServletRequest request;
        public final Resource resource;
        public final ResourceResolver resolver;
        public final Node node;
        public final ValueMap properties;
        public final String requestImageType;

        public ImageContext(SlingHttpServletRequest request, String type) {
            this.request = request;
            this.resource = request.getResource();
            this.resolver = request.getResourceResolver();
            this.node = (Node)this.resource.adaptTo(Node.class);
            ValueMap props = (ValueMap)this.resource.adaptTo(ValueMap.class);
            this.properties = props == null ? ValueMap.EMPTY : props;
            this.requestImageType = type;
        }
    }
}

