/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget.servlets;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -5743114344802542122L;
    private static final Logger log = LoggerFactory.getLogger(DialogServlet.class);
    private static final String CQ_DIALOG = "cq:Dialog";
    private static final String PARAM_JSON = "json";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        RequestParameterMap params = request.getRequestParameterMap();
        RequestParameter dialog = params.getValue(PARAM_JSON);
        HtmlResponse htmlResponse = new HtmlResponse();
        if (dialog != null) {
            try {
                JSONObject json = new JSONObject(new JSONTokener(dialog.getString()));
                Node node = (Node)request.getResource().adaptTo(Node.class);
                Node parent = node.getParent();
                String name = node.getName();
                node.remove();
                node = parent.addNode(name, this.getPrimaryType(json, CQ_DIALOG));
                this.storeDialog(json, node);
                parent.save();
            }
            catch (Exception e) {
                log.error("Error storing dialog", (Throwable)e);
                htmlResponse.setError((Throwable)e);
            }
        }
        htmlResponse.setTitle("Dialog saved successfully");
        htmlResponse.setStatus(200, "Dialog saved successfully");
        htmlResponse.setPath(request.getRequestPathInfo().getResourcePath());
        htmlResponse.setLocation(request.getRequestPathInfo().getResourcePath());
        try {
            htmlResponse.send((HttpServletResponse)response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private void storeDialog(JSONObject json, Node node) throws Exception {
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("jcr:")) continue;
            if (json.optJSONObject(key) != null) {
                this.storeDialog(json.getJSONObject(key), node.addNode(key, this.getPrimaryType(json.getJSONObject(key), "nt:unstructured")));
                continue;
            }
            node.setProperty(key, json.getString(key));
        }
    }

    private String getPrimaryType(JSONObject json, String defaultType) throws JSONException {
        return json.has("jcr:primaryType") ? json.getString("jcr:primaryType") : defaultType;
    }
}

