/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget.servlets;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.extwidget.ExtTreeJsonWriter;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

public class ExtTreeServlet
extends AbstractPredicateServlet {
    private static final long serialVersionUID = 4957052351412503213L;
    public static final String INFINITY = "infinity";
    public static final String TIDY = "tidy";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        String[] sels = req.getRequestPathInfo().getSelectors();
        int depth = 0;
        if (sels.length > 1) {
            if (sels[1].equals(INFINITY)) {
                depth = Integer.MAX_VALUE;
            } else {
                try {
                    depth = Integer.parseInt(sels[1]);
                }
                catch (NumberFormatException e) {
                    throw new ServletException("Invalid depth specifier: " + sels[1]);
                }
            }
        }
        ExtTreeJsonWriter w = new ExtTreeJsonWriter(req.getResourceResolver(), predicate, depth);
        w.setTidy("true".equals(req.getParameter(TIDY)));
        w.write((Writer)resp.getWriter(), req.getResource());
    }

    protected int selectorPredicateStart() {
        return 2;
    }
}

