/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget.servlets;

import com.day.cq.extwidget.servlets.AbstractImageServlet;
import com.day.image.Layer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.ComponentContext;

public class ImageSpriteServlet
extends AbstractImageServlet {
    public static final String MAX_WIDTH_PROPERTY = "maxWidth";
    public static final String MAX_HEIGHT_PROPERTY = "maxHeight";
    private static final long YEAR_IN_MS = 31536000000L;
    private int maxWidth = 1000;
    private int maxHeight = 1000;
    private static Map<String, Color> CSS_COLORS = new HashMap<String, Color>();

    protected void activate(ComponentContext context) {
        this.maxWidth = (Integer)context.getProperties().get(MAX_WIDTH_PROPERTY);
        this.maxHeight = (Integer)context.getProperties().get(MAX_HEIGHT_PROPERTY);
    }

    protected Layer createLayer(AbstractImageServlet.ImageContext context) throws RepositoryException, IOException {
        Parser parser = new Parser(context.request.getRequestPathInfo().getSelectors());
        Integer width = parser.nextIntToken();
        Integer height = parser.nextIntToken();
        if (width == null || height == null || width > this.maxWidth || height > this.maxHeight) {
            return null;
        }
        Layer layer = new Layer(width.intValue(), height.intValue(), null);
        layer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = parser.nextShape();
        while (shape != null) {
            shape.draw(layer);
            shape = parser.nextShape();
        }
        return layer;
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, AbstractImageServlet.ImageContext context, Layer layer) throws IOException, RepositoryException {
        response.setDateHeader("Expires", System.currentTimeMillis() + 31536000000L);
        super.writeLayer(request, response, context, layer);
    }

    protected static Color getColor(String colorStr) {
        if (CSS_COLORS.containsKey(colorStr)) {
            return CSS_COLORS.get(colorStr);
        }
        try {
            if (colorStr.startsWith("rgb(") || colorStr.startsWith("rgb<")) {
                String[] splits = (colorStr = colorStr.substring(4, colorStr.length() - 1)).split(",");
                if (splits.length == 3) {
                    int r = Integer.parseInt(splits[0].trim());
                    int g = Integer.parseInt(splits[1].trim());
                    int b = Integer.parseInt(splits[2].trim());
                    return new Color(r, g, b);
                }
            } else if (colorStr.startsWith("rgba(") || colorStr.startsWith("rgba<")) {
                String[] splits = (colorStr = colorStr.substring(5, colorStr.length() - 1)).split(",");
                if (splits.length == 4) {
                    int r = Integer.parseInt(splits[0].trim());
                    int g = Integer.parseInt(splits[1].trim());
                    int b = Integer.parseInt(splits[2].trim());
                    int a = Integer.parseInt(splits[3].trim());
                    return new Color(r, g, b, a);
                }
            } else {
                if (colorStr.length() == 1) {
                    int c = 17 * Integer.parseInt(colorStr, 16);
                    return new Color(c, c, c);
                }
                if (colorStr.length() == 2) {
                    int c = Integer.parseInt(colorStr, 16);
                    return new Color(c, c, c);
                }
                if (colorStr.length() == 3) {
                    int r = 17 * Integer.parseInt(colorStr.substring(0, 1), 16);
                    int g = 17 * Integer.parseInt(colorStr.substring(1, 2), 16);
                    int b = 17 * Integer.parseInt(colorStr.substring(2, 3), 16);
                    return new Color(r, g, b);
                }
                if (colorStr.length() == 6) {
                    int r = Integer.parseInt(colorStr.substring(0, 2), 16);
                    int g = Integer.parseInt(colorStr.substring(2, 4), 16);
                    int b = Integer.parseInt(colorStr.substring(4, 6), 16);
                    return new Color(r, g, b);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    static {
        CSS_COLORS.put("aqua", new Color(0, 255, 255));
        CSS_COLORS.put("black", Color.black);
        CSS_COLORS.put("blue", Color.blue);
        CSS_COLORS.put("fuchsia", new Color(255, 0, 255));
        CSS_COLORS.put("gray", Color.gray);
        CSS_COLORS.put("green", new Color(0, 128, 0));
        CSS_COLORS.put("lime", Color.green);
        CSS_COLORS.put("maroon", new Color(128, 0, 0));
        CSS_COLORS.put("navy", new Color(0, 0, 128));
        CSS_COLORS.put("olive", new Color(128, 128, 0));
        CSS_COLORS.put("purple", new Color(128, 0, 128));
        CSS_COLORS.put("red", Color.red);
        CSS_COLORS.put("silver", new Color(192, 192, 192));
        CSS_COLORS.put("teal", new Color(0, 128, 128));
        CSS_COLORS.put("white", Color.white);
        CSS_COLORS.put("yellow", Color.yellow);
        CSS_COLORS.put("transparent", new Color(0, 0, 0, 0));
    }

    private static class AlphaComp
    extends Shape {
        static final String TOKEN = "ac";
        AlphaComposite ac;

        private AlphaComp() {
        }

        boolean parse(Parser parser) {
            String type = parser.nextToken();
            if (type == null) {
                return false;
            }
            if ("src".equals(type)) {
                this.ac = AlphaComposite.Src;
            } else if ("srcAtop".equals(type)) {
                this.ac = AlphaComposite.SrcAtop;
            } else if ("srcIn".equals(type)) {
                this.ac = AlphaComposite.SrcIn;
            } else if ("srcOut".equals(type)) {
                this.ac = AlphaComposite.SrcOut;
            } else if ("srcOver".equals(type)) {
                this.ac = AlphaComposite.SrcOver;
            } else if ("dst".equals(type)) {
                this.ac = AlphaComposite.Dst;
            } else if ("dstAtop".equals(type)) {
                this.ac = AlphaComposite.DstAtop;
            } else if ("dstIn".equals(type)) {
                this.ac = AlphaComposite.DstIn;
            } else if ("dstOut".equals(type)) {
                this.ac = AlphaComposite.DstOut;
            } else if ("dstOver".equals(type)) {
                this.ac = AlphaComposite.DstOver;
            } else if ("clear".equals(type)) {
                this.ac = AlphaComposite.Clear;
            } else if ("xor".equals(type)) {
                this.ac = AlphaComposite.Xor;
            }
            return true;
        }

        void draw(Layer layer) {
            layer.setComposite((Composite)this.ac);
        }

        java.awt.Shape createAWTShape() {
            return null;
        }
    }

    private static class Ellipse
    extends Rect {
        static final String TOKEN = "ellipse";

        private Ellipse() {
        }

        java.awt.Shape createAWTShape() {
            return new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    private static class Poly
    extends Rect {
        static final String TOKEN = "poly";
        Polygon polygon;

        private Poly() {
        }

        boolean parse(Parser parser) {
            this.polygon = new Polygon();
            int i = 0;
            while (parser.nextTokenIsInt()) {
                Integer x = parser.nextIntToken();
                if (!parser.nextTokenIsInt()) break;
                Integer y = parser.nextIntToken();
                this.polygon.addPoint(x, y);
                ++i;
            }
            this.parseFillAndStroke(parser);
            return true;
        }

        java.awt.Shape createAWTShape() {
            return this.polygon;
        }
    }

    private static class RoundRect
    extends Rect {
        static final String TOKEN = "roundrect";
        float roundness;

        private RoundRect() {
        }

        boolean parse(Parser parser) {
            if (!this.parsePos(parser)) {
                return false;
            }
            if (!this.parseSize(parser)) {
                return false;
            }
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.roundness = parser.nextIntToken().intValue();
            this.parseFillAndStroke(parser);
            return true;
        }

        java.awt.Shape createAWTShape() {
            return new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, this.roundness, this.roundness);
        }

        void draw(Layer layer) {
            super.draw(layer);
        }
    }

    private static class Rect
    extends Shape {
        static final String TOKEN = "rect";
        int width;
        int height;

        private Rect() {
        }

        boolean parse(Parser parser) {
            if (!this.parsePos(parser)) {
                return false;
            }
            if (!this.parseSize(parser)) {
                return false;
            }
            this.parseFillAndStroke(parser);
            return true;
        }

        boolean parseSize(Parser parser) {
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.width = parser.nextIntToken();
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.height = parser.nextIntToken();
            return true;
        }

        java.awt.Shape createAWTShape() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    private static class Line
    extends Shape {
        static final String TOKEN = "line";
        int x2;
        int y2;

        private Line() {
        }

        boolean parse(Parser parser) {
            if (!this.parsePos(parser)) {
                return false;
            }
            if (!this.parseEndPos(parser)) {
                return false;
            }
            this.parseFillAndStroke(parser);
            return true;
        }

        boolean parseEndPos(Parser parser) {
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.x2 = parser.nextIntToken();
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.y2 = parser.nextIntToken();
            return true;
        }

        java.awt.Shape createAWTShape() {
            return new Line2D.Double(this.x, this.y, this.x2, this.y2);
        }
    }

    private static class Stroke {
        static final String TOKEN = "S";
        float strokeWidth;
        Color color;

        private Stroke() {
        }

        boolean parse(Parser parser) {
            if (!TOKEN.equals(parser.peekNextToken())) {
                return false;
            }
            parser.nextToken();
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.strokeWidth = (float)parser.nextIntToken().intValue() / 10.0f;
            String colorStr = parser.nextToken();
            if (colorStr == null) {
                return false;
            }
            this.color = ImageSpriteServlet.getColor(colorStr);
            return true;
        }

        void apply(Layer layer) {
            layer.setPaint((Paint)this.color);
            layer.setStroke((java.awt.Stroke)new BasicStroke(this.strokeWidth, 2, 2));
        }
    }

    private static class Fill {
        static final String TOKEN = "F";
        Color color;
        GradientPaint gradientPaint;

        private Fill() {
        }

        boolean parse(Parser parser) {
            if (!TOKEN.equals(parser.peekNextToken())) {
                return false;
            }
            parser.nextToken();
            String colorStr = parser.nextToken();
            if (colorStr == null) {
                return false;
            }
            this.color = ImageSpriteServlet.getColor(colorStr);
            if (parser.nextTokenIsInt()) {
                Integer x1 = parser.nextIntToken();
                if (!parser.nextTokenIsInt()) {
                    return true;
                }
                Integer y1 = parser.nextIntToken();
                colorStr = parser.nextToken();
                if (colorStr == null) {
                    return false;
                }
                Color color2 = ImageSpriteServlet.getColor(colorStr);
                if (color2 == null) {
                    return true;
                }
                if (!parser.nextTokenIsInt()) {
                    return true;
                }
                Integer x2 = parser.nextIntToken();
                if (!parser.nextTokenIsInt()) {
                    return true;
                }
                Integer y2 = parser.nextIntToken();
                this.gradientPaint = new GradientPaint(x1.intValue(), y1.intValue(), this.color, x2.intValue(), y2.intValue(), color2);
            }
            return true;
        }

        void apply(Layer layer) {
            if (this.gradientPaint != null) {
                layer.setPaint((Paint)this.gradientPaint);
            } else {
                layer.setPaint((Paint)this.color);
            }
        }
    }

    private static abstract class Shape {
        int x;
        int y;
        Fill fill;
        Stroke stroke;
        boolean strokeBeforeFill = false;

        private Shape() {
        }

        abstract boolean parse(Parser var1);

        boolean parsePos(Parser parser) {
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.x = parser.nextIntToken();
            if (!parser.nextTokenIsInt()) {
                return false;
            }
            this.y = parser.nextIntToken();
            return true;
        }

        void parseFillAndStroke(Parser parser) {
            if ("F".equals(parser.peekNextToken())) {
                Stroke stroke;
                this.strokeBeforeFill = false;
                Fill fill = new Fill();
                if (fill.parse(parser)) {
                    this.fill = fill;
                }
                if ((stroke = new Stroke()).parse(parser)) {
                    this.stroke = stroke;
                }
            } else if ("S".equals(parser.peekNextToken())) {
                Fill fill;
                this.strokeBeforeFill = true;
                Stroke stroke = new Stroke();
                if (stroke.parse(parser)) {
                    this.stroke = stroke;
                }
                if ((fill = new Fill()).parse(parser)) {
                    this.fill = fill;
                }
            }
        }

        boolean hasFill() {
            return this.fill != null;
        }

        boolean hasStroke() {
            return this.stroke != null;
        }

        void draw(Layer layer) {
            java.awt.Shape awtShape = this.createAWTShape();
            if (this.strokeBeforeFill) {
                if (this.hasStroke()) {
                    this.stroke.apply(layer);
                    layer.draw(awtShape);
                }
                if (this.hasFill()) {
                    this.fill.apply(layer);
                    layer.fill(awtShape);
                }
            } else {
                if (this.hasFill()) {
                    this.fill.apply(layer);
                    layer.fill(awtShape);
                }
                if (this.hasStroke()) {
                    this.stroke.apply(layer);
                    layer.draw(awtShape);
                }
            }
        }

        abstract java.awt.Shape createAWTShape();
    }

    private static class Parser {
        private final String[] selectors;
        private int pos = 0;

        public Parser(String[] selectors) {
            this.selectors = selectors;
        }

        String peekNextToken() {
            if (this.pos >= this.selectors.length) {
                return null;
            }
            return this.selectors[this.pos];
        }

        String nextToken() {
            if (this.pos >= this.selectors.length) {
                return null;
            }
            return this.selectors[this.pos++];
        }

        boolean nextTokenIsInt() {
            return this.getInt(this.peekNextToken()) != null;
        }

        Integer nextIntToken() {
            String token = this.nextToken();
            if (token == null) {
                return null;
            }
            return this.getInt(token);
        }

        private Integer getInt(String str) {
            if (str == null) {
                return null;
            }
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        Shape nextShape() {
            String type = this.nextToken();
            if (type == null) {
                return null;
            }
            Shape shape = null;
            if ("line".equals(type)) {
                shape = new Line();
            } else if ("rect".equals(type)) {
                shape = new Rect();
            } else if ("roundrect".equals(type)) {
                shape = new RoundRect();
            } else if ("poly".equals(type)) {
                shape = new Poly();
            } else if ("ellipse".equals(type)) {
                shape = new Ellipse();
            } else if ("ac".equals(type)) {
                shape = new AlphaComp();
            }
            if (shape == null) {
                return null;
            }
            if (!((Shape)shape).parse(this)) {
                return null;
            }
            return shape;
        }
    }
}

