/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.extwidget.servlets;

import com.day.cq.commons.LabeledResource;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.text.Text;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceListServlet
extends AbstractPredicateServlet {
    private static final Logger log = LoggerFactory.getLogger(ReferenceListServlet.class);
    public static final String PARAM_NAME_REFERENCELIST = "referencelist";
    public static final String PARAM_NAME_TIDY = "tidy";
    public static final String PARAM_NAME_PROPERTYNAME = "propertyname";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        ResourceResolver resourceResolver = req.getResourceResolver();
        TidyJSONWriter writer = new TidyJSONWriter((Writer)resp.getWriter());
        writer.setTidy("true".equals(req.getParameter(PARAM_NAME_TIDY)));
        try {
            writer.array();
            String[] referenceList = req.getParameterValues(PARAM_NAME_REFERENCELIST);
            if (req.getParameter(PARAM_NAME_PROPERTYNAME) != null) {
                ValueMap properties = (ValueMap)req.getResource().adaptTo(ValueMap.class);
                referenceList = (String[])properties.get(req.getParameter(PARAM_NAME_PROPERTYNAME), String[].class);
            }
            if (referenceList != null) {
                for (String path : referenceList) {
                    Resource resource = resourceResolver.getResource(path);
                    if (resource == null || predicate != null && !predicate.evaluate((Object)resource)) continue;
                    writer.object();
                    LabeledResource lr = (LabeledResource)resource.adaptTo(LabeledResource.class);
                    String name = Text.getName((String)resource.getPath());
                    writer.key("path").value((Object)resource.getPath());
                    writer.key("name").value((Object)name);
                    if (lr == null) {
                        writer.key("text").value((Object)name);
                    } else {
                        writer.key("text").value((Object)(lr.getTitle() == null ? name : lr.getTitle()));
                        if (lr.getDescription() != null) {
                            writer.key("description").value((Object)lr.getDescription());
                        }
                    }
                    writer.key("type").value((Object)resource.getResourceType());
                    writer.key("cls").value((Object)"file");
                    writer.key("leaf").value(true);
                    writer.endObject();
                }
            }
            writer.endArray();
        }
        catch (JSONException e) {
            log.error("error while assembling JSON: ", (Throwable)e);
        }
    }
}

