/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.theme.impl;

import com.day.cq.commons.jcr.AbstractRepositoryService;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.theme.Theme;
import com.day.cq.theme.ThemeRegistration;
import com.day.cq.theme.impl.PlainTheme;
import com.day.text.Text;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryThemeRegistration
extends AbstractRepositoryService
implements ThemeRegistration,
EventListener {
    public static final String EVENT_TOPIC = "com/day/cq/wcm/core/theme/ProfileChanged";
    private final Map<String, Theme> themes = new HashMap<String, Theme>();
    private static final String THEME_ROOT_PROPERTY = "repothemereg.root";
    private static final String THEME_NAME_PROPERTY = "repothemereg.themename";
    private static final String ROOT_NT_NAME = "repothemereg.rootntname";
    private static final String THEME_NT_NAME = "nt:unstructured";
    private static final Logger log = LoggerFactory.getLogger(RepositoryThemeRegistration.class);
    private String defaultThemePath;
    private String rootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Theme getTheme(String id) throws SlingException {
        Map<String, Theme> map = this.themes;
        synchronized (map) {
            Theme theme = this.themes.get(id);
            if (theme == null && (theme = this.loadTheme(id)) != null) {
                this.themes.put(id, theme);
            }
            return theme;
        }
    }

    protected void activate(ComponentContext componentContext) throws SlingException {
        try {
            Dictionary properties = componentContext.getProperties();
            this.rootPath = (String)properties.get(THEME_ROOT_PROPERTY);
            Node themeNode = this.initRoot(this.rootPath, properties);
            this.defaultThemePath = themeNode.getPath();
            this.loadDefaultTheme(themeNode);
            this.registerListen(this.rootPath);
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), (Throwable)e);
        }
    }

    private void loadDefaultTheme(Node themeNode) throws RepositoryException {
        PlainTheme theme = new PlainTheme(this.getResourceResolver().getResource(themeNode.getPath()));
        this.themes.put(theme.getPath(), theme);
    }

    protected void deactivate(ComponentContext componentContext) {
        try {
            this.getAdminSession().getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException re) {
            log.error("Cannot unregister RepositoryComponentRegistration as observation listener");
        }
        this.themes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator eventIterator) {
        boolean hasEvent = false;
        while (!hasEvent && eventIterator.hasNext()) {
            try {
                String eventPath = eventIterator.nextEvent().getPath();
                hasEvent = Text.isDescendantOrEqual((String)this.defaultThemePath, (String)eventPath);
            }
            catch (RepositoryException repositoryException) {}
        }
        if (hasEvent) {
            log.debug("Themses have event...");
            Map<String, Theme> map = this.themes;
            synchronized (map) {
                try {
                    this.themes.clear();
                    log.debug("....cleared Themses");
                }
                catch (SlingException e) {
                    log.error("Can not refresch default Theme: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private void registerListen(String rootPath) throws RepositoryException {
        Workspace workspace = this.getAdminSession().getWorkspace();
        ObservationManager omgr = workspace.getObservationManager();
        omgr.addEventListener((EventListener)this, 31, rootPath, true, null, null, false);
        log.debug("Register RepositoryThemeRegistration as Observation-listener to root {}", (Object)rootPath);
    }

    private Theme loadTheme(String id) throws SlingException {
        Theme theme;
        block6: {
            theme = null;
            Resource res = this.getResourceResolver().getResource(id);
            if (res != null) {
                try {
                    if (res.adaptTo(Theme.class) != null) {
                        log.debug("Resource for name {} is of type RepositoryResource", (Object)id);
                        theme = (Theme)res.adaptTo(Theme.class);
                        break block6;
                    }
                    if (res.adaptTo(Node.class) != null && ((Node)res.adaptTo(Node.class)).isNodeType("nt:file")) {
                        log.debug("Resource for name {} is a PlainResource", (Object)id);
                        theme = new PlainTheme(res);
                        break block6;
                    }
                    log.debug("resource for name {} is not a Theme -> return <null>", (Object)id);
                }
                catch (RepositoryException e) {
                    log.error("could not load theme at {} : {} -> return  <null> ", (Object)id, (Object)e.getMessage());
                }
            } else {
                log.debug("no theme for name {} -> return <null>", (Object)id);
            }
        }
        return theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node initRoot(String root, Dictionary<String, Object> properties) throws RepositoryException {
        Session session = this.getAdminSession();
        String name = (String)properties.get(THEME_NAME_PROPERTY);
        String path = root + "/" + name;
        this.assertNode(session, root, (String)properties.get(ROOT_NT_NAME));
        Node themeNode = this.assertNode(session, path, THEME_NT_NAME);
        if (session.hasPendingChanges()) {
            try {
                session.save();
            }
            finally {
                if (session.hasPendingChanges()) {
                    log.warn("could not save theme-root at {}: {}: revert", (Object)root);
                    session.refresh(false);
                }
            }
        }
        return themeNode;
    }

    private Node assertNode(Session session, String path, String ntName) throws RepositoryException {
        Node node;
        if ("".equals(path)) {
            node = session.getRootNode();
        } else if (session.itemExists(path)) {
            Item item = session.getItem(path);
            if (!item.isNode()) {
                throw new IllegalArgumentException("Item at path " + path + " expected Node");
            }
            node = (Node)item;
        } else {
            Node parent = this.assertNode(session, ResourceUtil.getParent((String)path), ntName);
            String name = JcrUtil.escapeIllegalJcrChars((String)Text.getName((String)path));
            node = parent.addNode(name, ntName);
            log.debug("create Path {} as theme's root", (Object)path);
        }
        return node;
    }
}

