/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.ClientLibrary;
import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.FileBundle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLibraryImpl
implements ClientLibrary {
    private final String path;
    private final String[] categories;
    private final String[] dependencies;
    private final String[] embeds;
    private final String[] channels;
    private final boolean isLegacy;
    private final Map<LibraryType, FileBundle> bundles = new HashMap<LibraryType, FileBundle>();
    private final String themeName;
    private final String libId;
    private final Map<String, ClientLibraryImpl> depLibs = new LinkedHashMap<String, ClientLibraryImpl>();
    private final Map<String, ClientLibraryImpl> embLibs = new LinkedHashMap<String, ClientLibraryImpl>();
    private final Set<String> embedders = new HashSet<String>();

    public ClientLibraryImpl(String path, String[] categories, String[] dependencies, String[] embeds, String[] channels, boolean legacy, String themeName, String libId) {
        this.categories = categories;
        this.dependencies = dependencies;
        this.embeds = embeds;
        this.channels = channels;
        this.path = path;
        this.isLegacy = legacy;
        this.themeName = themeName;
        this.libId = libId;
    }

    public Map<String, ClientLibraryImpl> getDependencies(boolean transitive) {
        LinkedHashMap<String, ClientLibraryImpl> deps = new LinkedHashMap<String, ClientLibraryImpl>();
        this.resolve(deps, transitive);
        if (transitive) {
            for (ClientLibraryImpl emb : this.embLibs.values()) {
                emb.resolve(deps, transitive);
            }
        }
        for (ClientLibraryImpl emb : this.embLibs.values()) {
            deps.remove(emb.getPath());
        }
        return deps;
    }

    public Map<String, ClientLibraryImpl> getEmbedded(LibraryType type) {
        if (this.embLibs.isEmpty()) {
            return this.embLibs;
        }
        LinkedHashMap<String, ClientLibraryImpl> libs = new LinkedHashMap<String, ClientLibraryImpl>();
        for (ClientLibraryImpl emb : this.embLibs.values()) {
            if (!emb.hasType(type) || this.themeName == null != (emb.themeName == null) || !Arrays.equals(this.channels, emb.channels)) continue;
            libs.put(emb.getPath(), emb);
        }
        return libs;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getThemeName() {
        return this.themeName;
    }

    @Override
    public String getThemeLibId() {
        return this.libId;
    }

    @Override
    public String getIncludePath(LibraryType type) {
        if (this.isLegacy || type == null) {
            return this.path;
        }
        if (this.bundles.containsKey((Object)type)) {
            return this.path + type.extension;
        }
        return null;
    }

    @Override
    public String[] getCategories() {
        return this.categories;
    }

    @Override
    public String[] getEmbeddedCategories() {
        return this.embeds;
    }

    @Override
    public String[] getDependentCategories() {
        return this.dependencies;
    }

    @Override
    public String[] getChannels() {
        return this.channels;
    }

    @Override
    public Set<LibraryType> getTypes() {
        return Collections.unmodifiableSet(this.bundles.keySet());
    }

    protected void addDependency(ClientLibraryImpl lib) {
        this.depLibs.put(lib.getPath(), lib);
    }

    protected void addEmbedded(ClientLibraryImpl lib) {
        this.embLibs.put(lib.getPath(), lib);
        lib.embedders.add(this.path);
    }

    protected FileBundle getBundle(LibraryType type) {
        return this.bundles.get((Object)type);
    }

    protected void addBundle(LibraryType type, FileBundle bundle) {
        this.bundles.put(type, bundle);
    }

    protected void clear() {
        this.depLibs.clear();
        this.embLibs.clear();
        this.embedders.clear();
    }

    protected Set<String> getEmbedders() {
        return this.embedders;
    }

    protected ClientLibraryImpl createCopy() {
        ClientLibraryImpl lib = new ClientLibraryImpl(this.path, this.categories, this.dependencies, this.embeds, this.channels, this.isLegacy, this.themeName, this.libId);
        lib.bundles.putAll(this.bundles);
        lib.depLibs.putAll(this.depLibs);
        lib.embLibs.putAll(this.embLibs);
        lib.embedders.addAll(this.embedders);
        return lib;
    }

    protected void relink(Map<String, ClientLibraryImpl> libs) {
        HashSet<String> paths = new HashSet<String>(this.depLibs.keySet());
        for (String path : paths) {
            this.depLibs.put(path, libs.get(path));
        }
        paths.clear();
        paths.addAll(this.embLibs.keySet());
        for (String path : paths) {
            this.embLibs.put(path, libs.get(path));
        }
    }

    private void resolve(Map<String, ClientLibraryImpl> collect, boolean transitive) {
        for (ClientLibraryImpl dep : this.depLibs.values()) {
            if (collect.containsKey(dep.getPath())) continue;
            if (transitive) {
                dep.resolve(collect, true);
            }
            collect.put(dep.getPath(), dep);
        }
    }

    private boolean hasType(LibraryType type) {
        return this.bundles.isEmpty() || type == null || this.bundles.containsKey((Object)type);
    }
}

