/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.AbstractBuilder;
import com.day.cq.widget.impl.JcrPropertyResource;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.types.resources.Resources;

public class CssFileBuilder
extends AbstractBuilder {
    private static final Pattern[] STRIP_PATTERN = new Pattern[16];
    private static final int lineBreakPos = 0;
    private String stripRoot = "";

    public CssFileBuilder(String stripRoot) {
        this.stripRoot = stripRoot.length() > 0 && !stripRoot.endsWith("/") ? stripRoot + "/" : stripRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File concatenate(Resources coll) throws IOException {
        File dest = File.createTempFile("cssfile", ".css");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)dest), "utf-8");
        for (JcrPropertyResource r : coll) {
            String src;
            InputStream in = r.getInputStream();
            try {
                src = IOUtils.toString((InputStream)in, (String)"utf-8");
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            if (r.getRelDepth() > 0) {
                Matcher m = STRIP_PATTERN[r.getRelDepth() - 1].matcher(src);
                src = m.replaceAll("url($1" + this.stripRoot + "$2$3)");
            }
            out.write(src);
            out.write("\n");
        }
        ((Writer)out).close();
        return dest;
    }

    protected void minify(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        CssCompressor compressor = new CssCompressor((Reader)isr);
        inputStream.close();
        OutputStreamWriter out = new OutputStreamWriter(outputStream, "utf-8");
        compressor.compress((Writer)out, 0);
        out.close();
    }

    public LibraryType getType() {
        return LibraryType.CSS;
    }

    static {
        for (int depth = 0; depth < STRIP_PATTERN.length; ++depth) {
            StringBuffer pattern = new StringBuffer("url\\(\\s*(['\"]?)");
            for (int i = 0; i < depth; ++i) {
                pattern.append("\\.\\./");
            }
            pattern.append("([^'\")]*)(['\"]?\\s*)\\)");
            CssFileBuilder.STRIP_PATTERN[depth] = Pattern.compile(pattern.toString());
        }
    }
}

