/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.impl.JcrPropertyResource;
import com.day.text.Text;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBundle {
    private static final Logger log = LoggerFactory.getLogger(FileBundle.class);
    private final LinkedHashSet<String> files;
    private final String id;
    private final String rootPath;
    private final String filePrefix;
    private long lastModified = -1L;
    private boolean dirty;
    private boolean overlayed;

    public FileBundle(Node root, String id, String includeFileName, String filePrefix) throws RepositoryException {
        this.id = id;
        this.rootPath = root.getPath();
        this.filePrefix = filePrefix == null ? "" : filePrefix;
        this.files = new LinkedHashSet();
        try {
            if (root.hasNode(includeFileName)) {
                this.scanIncludeList(root, includeFileName);
            } else {
                this.scanFiles(root);
            }
        }
        catch (Exception e) {
            log.error("Error occurred while scanning files for: " + this.rootPath, (Throwable)e);
        }
        log.debug("getFiles(): {} files found", (Object)this.files.size());
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isOverlayed() {
        return this.overlayed;
    }

    public String getId() {
        return this.id;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void addResources(Session session, String rootPath, Resources resources) throws RepositoryException {
        int rootDepth = Text.explode((String)rootPath, (int)47).length;
        for (String file : this.files) {
            Property p = session.getProperty(file + "/jcr:content/jcr:data");
            int relDepth = Text.explode((String)file, (int)47).length - rootDepth;
            resources.add((ResourceCollection)new JcrPropertyResource(p, file, relDepth));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanIncludeList(Node root, String fileName) throws RepositoryException, IOException {
        this.overlayed = false;
        Node includeFile = root.getNode(fileName);
        this.updateLastModified(includeFile);
        InputStream includesList = includeFile.getProperty("jcr:content/jcr:data").getBinary().getStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(includesList));
        try {
            String line;
            String basePath = this.rootPath + this.filePrefix;
            while ((line = reader.readLine()) != null) {
                Node node;
                String path = line.trim();
                if (path.length() == 0 || path.startsWith("#")) {
                    if (!path.startsWith("#base=") || (basePath = path.substring(6)).startsWith("/")) continue;
                    basePath = this.rootPath + this.filePrefix + "/" + basePath;
                    continue;
                }
                if (!path.startsWith("/")) {
                    path = basePath + "/" + path;
                }
                if (!root.getSession().itemExists(path)) {
                    log.warn("Referenced path in {} does not exist: {}", (Object)fileName, (Object)path);
                    continue;
                }
                if (path.startsWith("/libs/")) {
                    String altPath = "/apps/" + path.substring(6);
                    if (root.getSession().nodeExists(altPath)) {
                        this.overlayed = true;
                        log.info("Library file {} overlayed by {}.", (Object)path, (Object)altPath);
                        path = altPath;
                    }
                }
                if (!(node = root.getSession().getNode(path)).hasProperty("jcr:content/jcr:data")) {
                    log.warn("Referenced node has no data: {}", (Object)path);
                    continue;
                }
                this.files.add(path);
                this.updateLastModified(node);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private void scanFiles(Node parent) throws RepositoryException {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.isNodeType("nt:file")) {
                this.files.add(node.getPath());
                this.updateLastModified(node);
                continue;
            }
            if (!node.isNodeType("nt:folder")) continue;
            this.scanFiles(node);
        }
    }

    private void updateLastModified(Node file) {
        try {
            long lastMod;
            if (file.hasProperty("jcr:content/jcr:lastModified") && (lastMod = file.getProperty("jcr:content/jcr:lastModified").getLong()) > this.lastModified) {
                this.lastModified = lastMod;
            }
        }
        catch (RepositoryException e) {
            String path;
            try {
                path = file.getPath();
            }
            catch (RepositoryException e1) {
                path = file.toString();
            }
            log.error("Error while updating last modified time for file: {}", (Object)path);
        }
    }
}

