/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.ClientLibraryImpl;
import com.day.cq.widget.impl.FileBundle;
import com.day.cq.widget.impl.HtmlLibraryManagerImpl;
import com.day.text.Text;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLibraryImpl
implements HtmlLibrary {
    private final String path;
    private final String rootPath;
    private final LibraryType type;
    private final FileBundle bundle;
    private final FileBundle[] embedded;
    private final HtmlLibraryManagerImpl mgr;

    protected HtmlLibraryImpl(HtmlLibraryManagerImpl mgr, ClientLibraryImpl library, LibraryType type, FileBundle bundle, FileBundle[] embedded) {
        this.type = type;
        this.rootPath = bundle.getRootPath();
        this.path = library.getIncludePath(type);
        this.bundle = bundle;
        this.embedded = embedded;
        this.mgr = mgr;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return Text.getName((String)this.path);
    }

    @Override
    public String getLibraryPath() {
        return this.rootPath;
    }

    @Override
    public LibraryType getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.mgr.getLastModified(this);
    }

    @Override
    public void send(HttpServletResponse response, boolean gzip) throws IOException {
        this.mgr.send(this, response, gzip);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mgr.getInputStream(this);
    }

    public FileBundle getBundle() {
        return this.bundle;
    }

    public long getBundleLastModified() {
        long lm = this.bundle.getLastModified();
        if (this.embedded != null) {
            for (FileBundle e : this.embedded) {
                if (e.getLastModified() <= lm) continue;
                lm = e.getLastModified();
            }
        }
        return lm;
    }

    public FileBundle[] getEmbedded() {
        return this.embedded;
    }

    @Override
    public List<String> getScripts() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.embedded != null) {
            for (FileBundle bundle : this.embedded) {
                for (String path : bundle.getFiles()) {
                    list.add(path);
                }
            }
        }
        for (String path : this.bundle.getFiles()) {
            list.add(path);
        }
        return list;
    }

    @Override
    public String getScripts(String delimiter) {
        String d = "";
        StringBuffer scripts = new StringBuffer();
        for (String path : this.getScripts()) {
            scripts.append(d).append("\"").append(path).append("\"");
            d = delimiter;
        }
        return scripts.toString();
    }
}

