/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.commons.Doctype;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.widget.ClientLibrary;
import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.AbstractBuilder;
import com.day.cq.widget.impl.ClientLibraryImpl;
import com.day.cq.widget.impl.CssFileBuilder;
import com.day.cq.widget.impl.FileBundle;
import com.day.cq.widget.impl.HtmlLibraryImpl;
import com.day.cq.widget.impl.JsFileBuilder;
import com.day.text.Text;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPOutputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.tools.ant.types.resources.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLibraryManagerImpl
implements HtmlLibraryManager,
EventListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String INCLUDED_SET_ATTR_NAME = HtmlLibraryManager.class.getName() + ".included";
    private static final String INCLUDES_TXT = "includes.txt";
    public static String TMP_LOCATION = "/var/clientlibs";
    private static final String CQ_CLIENT_LIBRARY_FOLDER = "cq:ClientLibraryFolder";
    private static final String DEFAULT_FIREBUG_LITE_PATH = "/libs/cq/ui/widgets/source/endorsed/firebug/firebug-lite.js";
    private static final Comparator<String> REV_PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return Text.compareHandles((String)o2, (String)o1);
        }
    };
    protected SlingRepository repository;
    protected static final String CONFIG_PROPERTY_MINIFY = "htmllibmanager.minify";
    protected static final String CONFIG_PROPERTY_DEBUG = "htmllibmanager.debug";
    protected static final String CONFIG_PROPERTY_GZIP = "htmllibmanager.gzip";
    protected static final String CONFIG_PROPERTY_TIMING = "htmllibmanager.timing";
    protected static final String CONFIG_PROPERTY_FIREBUG_LITE_PATH = "htmllibmanager.firebuglite.path";
    protected static final String CONFIG_PROPERTY_DEBUG_CONSOLE = "htmllibmanager.debug.console";
    protected static final String CONFIG_PROPERTY_DEBUG_INIT_JS = "htmllibmanager.debug.init.js";
    protected static final String CONFIG_PROPERTY_DEFAULT_THEME_NAME = "htmllibmanager.defaultthemename";
    protected static final String CONFIG_PROPERTY_DEFAULT_USER_THEME_NAME = "htmllibmanager.defaultuserthemename";
    protected static final String CONFIG_CLIENT_MANAGER_CATEGORY = "htmllibmanager.clientmanager";
    protected static final String CONFIG_PROPERTY_PATH_LIST = "htmllibmanager.path.list";
    private static final String CUSTOM_JAVA_SCRIPT_PATH = "customJavaScriptPath";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String CSS = "css";
    private static final String JS = "js";
    private static final String PN_CATEGORIES = "categories";
    private static final String PN_DEPENDENCIES = "dependencies";
    private static final String PN_EMBED = "embed";
    private static final String PN_CHANNELS = "channels";
    private final TreeMap<String, Map<String, ClientLibraryImpl>> libsByCategory = new TreeMap();
    private final TreeMap<String, ClientLibraryImpl> libsByPath = new TreeMap();
    private final Set<String> channels = new HashSet<String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Session admin;
    private boolean enableTiming;
    private boolean enableDebugConsole;
    private String firebugLiteJSPath;
    private String debugInitJS;
    private boolean enableMinify;
    private boolean enableDebug;
    private boolean enableGzip;
    private boolean isLoaded;
    private boolean isResolved;
    private String defaultThemeName = "default";
    private String defaultUserThemeName = "default";
    private String clientMgrCategory;
    private String[] allowedPaths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Map<String, Object> properties) {
        this.lock.writeLock().lock();
        try {
            this.update(properties);
            this.admin = this.repository.loginAdministrative(null);
            this.admin.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, "/", true, null, null, true);
        }
        catch (RepositoryException e) {
            this.log.error("Error during initialization of component.", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Map<String, Object> properties) {
        this.lock.writeLock().lock();
        try {
            this.enableMinify = (Boolean)properties.get(CONFIG_PROPERTY_MINIFY);
            this.enableTiming = (Boolean)properties.get(CONFIG_PROPERTY_TIMING);
            this.firebugLiteJSPath = (String)properties.get(CONFIG_PROPERTY_FIREBUG_LITE_PATH);
            this.enableDebugConsole = (Boolean)properties.get(CONFIG_PROPERTY_DEBUG_CONSOLE);
            this.enableDebug = (Boolean)properties.get(CONFIG_PROPERTY_DEBUG);
            this.debugInitJS = (String)properties.get(CONFIG_PROPERTY_DEBUG_INIT_JS);
            this.defaultThemeName = (String)properties.get(CONFIG_PROPERTY_DEFAULT_THEME_NAME);
            this.defaultUserThemeName = (String)properties.get(CONFIG_PROPERTY_DEFAULT_USER_THEME_NAME);
            this.clientMgrCategory = (String)properties.get(CONFIG_CLIENT_MANAGER_CATEGORY);
            this.enableGzip = (Boolean)properties.get(CONFIG_PROPERTY_GZIP);
            this.allowedPaths = OsgiUtil.toStringArray((Object)properties.get(CONFIG_PROPERTY_PATH_LIST));
            this.isLoaded = false;
            this.isResolved = false;
            this.libsByCategory.clear();
            this.libsByPath.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        block5: {
            this.lock.writeLock().lock();
            try {
                if (this.admin == null) break block5;
                try {
                    this.admin.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                this.admin.logout();
                this.admin = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void writeIncludes(SlingHttpServletRequest request, Writer out, String ... categories) throws IOException {
        this.internalWriteIncludes(request, out, null, this.getDefaultThemeName(request), null, categories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void internalWriteIncludes(SlingHttpServletRequest request, Writer out, Boolean themed, String theme, LibraryType reqType, String ... categories) throws IOException {
        Map<String, ClientLibrary> libs;
        this.writeDebugConsole(request, out);
        this.lock.readLock().lock();
        try {
            libs = this.lockedGetLibs(categories, reqType, themed, theme, true);
        }
        finally {
            this.lock.readLock().unlock();
        }
        boolean dynamic = false;
        for (ClientLibrary lib : libs.values()) {
            if (lib.getChannels().length <= 0) continue;
            dynamic = true;
            break;
        }
        if (dynamic) {
            void var12_16;
            this.internalWriteJsInclude(request, out, null, null, new String[]{this.clientMgrCategory});
            this.writeURLInfo(request, out, dynamic);
            boolean isDebug = this.debugClientLibs(request);
            StringWriter buffer = new StringWriter();
            JSONWriter json = new JSONWriter((Writer)buffer);
            json.setTidy(isDebug);
            boolean bl = false;
            try {
                json.array();
                for (ClientLibrary lib : libs.values()) {
                    for (LibraryType type : lib.getTypes()) {
                        if (reqType != null && type != reqType) continue;
                        String path = lib.getIncludePath(type);
                        if (!this.isIncluded(request, path)) {
                            ++var12_16;
                            if (isDebug) {
                                path = path + "?debug=true";
                            }
                            json.object();
                            json.key("p").value((Object)(request.getContextPath() + path));
                            json.key("c").array();
                            for (String c : lib.getChannels()) {
                                json.value((Object)c);
                            }
                            json.endArray();
                            json.endObject();
                        }
                        for (ClientLibrary clientLibrary : lib.getEmbedded(type).values()) {
                            this.isIncluded(request, clientLibrary.getIncludePath(type));
                        }
                    }
                }
                json.endArray();
            }
            catch (JSONException e) {
                IOException io = new IOException("Error while generating JSON object");
                io.initCause(e);
                throw io;
            }
            if (var12_16 > 0) {
                out.write("<script type=\"text/javascript\">\n");
                out.write("CQClientLibraryManager.write(");
                out.write(buffer.toString());
                out.write("," + isDebug + ");\n</script>\n");
            }
        } else {
            this.writeURLInfo(request, out, dynamic);
            if (reqType == null || reqType == LibraryType.JS) {
                for (ClientLibrary lib : libs.values()) {
                    if (!lib.getTypes().contains((Object)LibraryType.JS)) continue;
                    this.writeJsInclude(request, out, lib.getIncludePath(LibraryType.JS), this.enableTiming);
                    for (ClientLibrary clientLibrary : lib.getEmbedded(LibraryType.JS).values()) {
                        this.isIncluded(request, clientLibrary.getIncludePath(LibraryType.JS));
                    }
                }
            }
            if (reqType == null || reqType == LibraryType.CSS) {
                for (ClientLibrary lib : libs.values()) {
                    if (!lib.getTypes().contains((Object)LibraryType.CSS)) continue;
                    this.writeCssInclude(request, out, lib.getIncludePath(LibraryType.CSS));
                    for (ClientLibrary clientLibrary : lib.getEmbedded(LibraryType.CSS).values()) {
                        this.isIncluded(request, clientLibrary.getIncludePath(LibraryType.CSS));
                    }
                }
            }
        }
    }

    private void writeURLInfo(SlingHttpServletRequest request, Writer out, boolean dynamic) throws IOException {
        if (this.getIncludedSet(request).size() <= 1) {
            RequestPathInfo info = request.getRequestPathInfo();
            String path = StringUtils.removeEnd((String)info.getResourcePath(), (String)"/jcr:content");
            String selectorString = info.getSelectorString();
            String[] selectors = info.getSelectors();
            Object[] escapedSelectors = new String[selectors.length];
            for (int i = 0; i < selectors.length; ++i) {
                escapedSelectors[i] = StringEscapeUtils.escapeJavaScript((String)selectors[i]);
            }
            String ext = info.getExtension();
            String suffix = info.getSuffix();
            String contextPath = request.getContextPath();
            out.write("<script type=\"text/javascript\">\n");
            out.write("CQURLInfo = {\n");
            out.write("    \"contextPath\": " + (StringUtils.isNotBlank((String)contextPath) ? "'" + StringEscapeUtils.escapeJavaScript((String)contextPath) + "'" : "null") + ",\n");
            out.write("    \"requestPath\": " + (StringUtils.isNotBlank((String)path) ? "'" + StringEscapeUtils.escapeJavaScript((String)path) + "'" : "null") + ",\n");
            out.write("    \"selectorString\": " + (StringUtils.isNotBlank((String)selectorString) ? "'" + StringEscapeUtils.escapeJavaScript((String)selectorString) + "'" : "null") + ",\n");
            out.write("    \"selectors\": " + (selectors.length > 0 ? "['" + StringUtils.join((Object[])escapedSelectors, (String)"','") + "']" : "[]") + ",\n");
            out.write("    \"extension\": " + (StringUtils.isNotBlank((String)ext) ? "'" + StringEscapeUtils.escapeJavaScript((String)ext) + "'" : "null") + ",\n");
            out.write("    \"suffix\": " + (StringUtils.isNotBlank((String)suffix) ? "'" + StringEscapeUtils.escapeJavaScript((String)suffix) + "'" : "null") + "\n");
            out.write("};");
            out.write("</script>\n");
        }
    }

    @Override
    public void writeJsInclude(SlingHttpServletRequest request, Writer out, String ... categories) throws IOException {
        this.internalWriteIncludes(request, out, null, this.getDefaultThemeName(request), LibraryType.JS, categories);
        try {
            String customJsPath;
            ResourceResolver resolver = request.getResourceResolver();
            Node node = (Node)request.getResource().adaptTo(Node.class);
            if (node != null && node.hasProperty(CUSTOM_JAVA_SCRIPT_PATH) && (customJsPath = node.getProperty(CUSTOM_JAVA_SCRIPT_PATH).getString()) != null && !customJsPath.equals("") && resolver.getResource(customJsPath) != null) {
                this.writeJsInclude(request, out, customJsPath, this.enableTiming);
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error during include custom js for {}: {}", (Object)request.getResource().getPath(), (Object)e.toString());
        }
    }

    @Override
    public void writeJsInclude(SlingHttpServletRequest request, Writer out, boolean themed, String ... categories) throws IOException {
        String themeName = themed ? this.getDefaultThemeName(request) : null;
        this.internalWriteIncludes(request, out, themed, themeName, LibraryType.JS, categories);
        try {
            String customJsPath;
            ResourceResolver resolver = request.getResourceResolver();
            Node node = (Node)request.getResource().adaptTo(Node.class);
            if (node != null && node.hasProperty(CUSTOM_JAVA_SCRIPT_PATH) && (customJsPath = node.getProperty(CUSTOM_JAVA_SCRIPT_PATH).getString()) != null && !customJsPath.equals("") && resolver.getResource(customJsPath) != null) {
                this.writeJsInclude(request, out, customJsPath, this.enableTiming);
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error during include custom js for {}: {}", (Object)request.getResource().getPath(), (Object)e.toString());
        }
    }

    @Override
    public void writeCssInclude(SlingHttpServletRequest request, Writer out, String ... categories) throws IOException {
        this.internalWriteIncludes(request, out, null, this.getDefaultThemeName(request), LibraryType.CSS, categories);
    }

    @Override
    public void writeCssInclude(SlingHttpServletRequest request, Writer out, boolean themed, String ... categories) throws IOException {
        String themeName = themed ? this.getDefaultThemeName(request) : null;
        this.internalWriteIncludes(request, out, themed, themeName, LibraryType.CSS, categories);
    }

    @Override
    public void writeThemeInclude(SlingHttpServletRequest request, Writer out, String ... categories) throws IOException {
        String themeName = this.getDefaultThemeName(request);
        this.internalWriteIncludes(request, out, true, themeName, LibraryType.JS, categories);
        this.internalWriteIncludes(request, out, null, themeName, LibraryType.CSS, categories);
    }

    private void writeDebugConsole(SlingHttpServletRequest request, Writer out) throws IOException {
        if (this.showDebugConsole(request)) {
            this.writeJsInclude(request, out, this.firebugLiteJSPath, false);
            if (this.debugInitJS != null && this.debugInitJS.length() > 0 && !this.isIncluded(request, this.debugInitJS)) {
                out.write("<script type=\"text/javascript\">\n");
                out.write(this.debugInitJS + "\n");
                out.write("</script>\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWriteJsInclude(SlingHttpServletRequest request, Writer out, Boolean themed, String themeName, String[] categories) throws IOException {
        Map<String, ClientLibrary> libs;
        this.writeDebugConsole(request, out);
        this.lock.readLock().lock();
        try {
            libs = this.lockedGetLibs(categories, LibraryType.JS, themed, themeName, true);
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (ClientLibrary lib : libs.values()) {
            this.writeJsInclude(request, out, lib.getIncludePath(LibraryType.JS), this.enableTiming);
            for (ClientLibrary clientLibrary : lib.getEmbedded(LibraryType.JS).values()) {
                this.isIncluded(request, clientLibrary.getIncludePath(LibraryType.JS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWriteCssInclude(SlingHttpServletRequest request, Writer out, Boolean themed, String themeName, String ... categories) throws IOException {
        Map<String, ClientLibrary> libs;
        this.lock.readLock().lock();
        try {
            libs = this.lockedGetLibs(categories, LibraryType.CSS, themed, themeName, true);
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (ClientLibrary lib : libs.values()) {
            this.writeCssInclude(request, out, lib.getIncludePath(LibraryType.CSS));
            for (ClientLibrary clientLibrary : lib.getEmbedded(LibraryType.CSS).values()) {
                this.isIncluded(request, clientLibrary.getIncludePath(LibraryType.CSS));
            }
        }
    }

    @Override
    public HtmlLibrary getLibrary(SlingHttpServletRequest request) {
        LibraryType type = LibraryType.fromRequest(request);
        if (type == null) {
            this.log.error("Unable to determine library type for request.");
            return null;
        }
        return this.getLibrary(type, request.getResource().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlLibrary getLibrary(LibraryType type, String path) {
        this.lock.readLock().lock();
        this.assertResolved();
        try {
            ClientLibraryImpl e = this.libsByPath.get(path);
            if (e == null) {
                this.log.warn("No library configured at {}", (Object)path);
                HtmlLibrary htmlLibrary = null;
                return htmlLibrary;
            }
            FileBundle bundle = e.getBundle(type);
            if (bundle == null) {
                this.log.warn("Library at {} does not provide type {}", (Object)path, (Object)type);
                HtmlLibrary htmlLibrary = null;
                return htmlLibrary;
            }
            LinkedList<FileBundle> bundles = new LinkedList<FileBundle>();
            for (ClientLibraryImpl lib : e.getEmbedded(type).values()) {
                FileBundle embedBundle = lib.getBundle(type);
                if (embedBundle == null) continue;
                bundles.add(embedBundle);
            }
            FileBundle[] embedded = bundles.isEmpty() ? null : bundles.toArray(new FileBundle[bundles.size()]);
            HtmlLibraryImpl htmlLibraryImpl = new HtmlLibraryImpl(this, e, type, bundle, embedded);
            return htmlLibraryImpl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isMinifyEnabled() {
        return this.enableMinify;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.enableDebug;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.enableGzip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClientLibrary> getLibraries(String[] categories, LibraryType type, boolean ignoreThemed, boolean transitive) {
        this.lock.readLock().lock();
        try {
            Collection<ClientLibrary> collection = this.lockedGetLibs(categories, type, ignoreThemed ? Boolean.valueOf(false) : null, null, transitive).values();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClientLibrary> getThemeLibraries(String[] categories, LibraryType type, String themeName, boolean transitive) {
        this.lock.readLock().lock();
        try {
            Collection<ClientLibrary> collection = this.lockedGetLibs(categories, type, true, themeName, transitive).values();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ClientLibrary> getLibraries() {
        this.lock.readLock().lock();
        try {
            this.assertResolved();
            TreeMap<String, ClientLibraryImpl> libs = new TreeMap<String, ClientLibraryImpl>();
            for (ClientLibraryImpl lib : this.libsByPath.values()) {
                libs.put(lib.getPath(), lib.createCopy());
            }
            for (ClientLibraryImpl lib : libs.values()) {
                lib.relink(libs);
            }
            TreeMap<String, ClientLibrary> treeMap = new TreeMap<String, ClientLibrary>((Map<String, ClientLibrary>)libs);
            return treeMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator iter) {
        HashSet<String> paths = new HashSet<String>();
        HashSet<String> added = new HashSet<String>();
        while (iter.hasNext()) {
            Event e = iter.nextEvent();
            try {
                String path = e.getPath();
                if (e.getType() != 1 && e.getType() != 2) {
                    path = Text.getRelativeParent((String)path, (int)1);
                }
                if (path.endsWith("/jcr:content")) {
                    path = Text.getRelativeParent((String)path, (int)1);
                }
                paths.add(path);
                if (e.getType() == 1) {
                    added.add(path);
                }
                if (path.startsWith("/apps/")) {
                    path = "/libs/" + path.substring(6);
                }
                paths.add(path);
                if (e.getType() != 1) continue;
                added.add(path);
            }
            catch (RepositoryException e1) {}
        }
        HashSet<String> modified = new HashSet<String>();
        this.lock.readLock().lock();
        try {
            for (String p : paths) {
                for (String root : this.libsByPath.keySet()) {
                    if (modified.contains(root) || !root.equals(p) && !p.startsWith(root + "/")) continue;
                    modified.add(root);
                }
            }
            for (String p : added) {
                try {
                    Node n = (Node)this.admin.getItem(p);
                    if (!n.isNodeType(CQ_CLIENT_LIBRARY_FOLDER)) continue;
                    modified.add(p);
                }
                catch (RepositoryException e) {}
            }
            added.clear();
            added.addAll(modified);
            for (String p : added) {
                ClientLibraryImpl lib = this.libsByPath.get(p);
                if (lib == null) continue;
                modified.addAll(lib.getEmbedders());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!modified.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                for (String p : modified) {
                    this.invalidate(p);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private boolean debugClientLibs(SlingHttpServletRequest request) {
        return this.enableDebug || "true".equals(request.getParameter("debugClientLibs"));
    }

    private boolean showDebugConsole(SlingHttpServletRequest request) {
        return this.enableDebugConsole || "true".equals(request.getParameter("debugConsole"));
    }

    private void writeJsInclude(SlingHttpServletRequest request, Writer out, String path, boolean timing) throws IOException {
        if (this.isIncluded(request, path)) {
            return;
        }
        out.write("<script type=\"text/javascript\" src=\"");
        out.write(request.getContextPath() + path);
        if (this.debugClientLibs(request)) {
            out.write("?debug=true");
        }
        out.write("\"></script>\n");
        if (timing) {
            out.write("<script type=\"text/javascript\">\n");
            out.write("  CQ.Timing.stamp('loaded " + request.getContextPath() + path + "');\n");
            out.write("</script>\n");
        }
    }

    private void writeCssInclude(SlingHttpServletRequest request, Writer out, String path) throws IOException {
        if (this.isIncluded(request, path)) {
            return;
        }
        Doctype doctype = Doctype.fromRequest((ServletRequest)request);
        String end = doctype != null && doctype.isXHTML() ? "/>\n" : ">\n";
        out.write("<link rel=\"stylesheet\" href=\"");
        out.write(request.getContextPath() + path);
        if (this.debugClientLibs(request)) {
            out.write("?debug=true");
        }
        out.write("\" type=\"text/css\"");
        out.write(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLoaded() {
        if (!this.isLoaded) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (!this.isLoaded) {
                    try {
                        this.loadLibs();
                        this.isLoaded = true;
                    }
                    catch (RepositoryException e) {
                        this.log.error("Cannot load js libraries", (Throwable)e);
                    }
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertResolved() {
        this.assertLoaded();
        if (!this.isResolved) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (!this.isResolved) {
                    for (ClientLibraryImpl lib : this.libsByPath.values()) {
                        lib.clear();
                    }
                    this.channels.clear();
                    HashSet<String> processed = new HashSet<String>();
                    LinkedList<String> paths = new LinkedList<String>(this.libsByPath.keySet());
                    while (!paths.isEmpty()) {
                        this.resolveLib(processed, (String)paths.remove(0));
                    }
                    this.isResolved = true;
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    private ClientLibraryImpl resolveLib(Set<String> processed, String path) {
        ClientLibraryImpl lib = this.libsByPath.get(path);
        if (lib != null && !processed.contains(path)) {
            for (String c : lib.getChannels()) {
                this.channels.add(c);
            }
            processed.add(path);
            for (String depPath : this.getLibsByCategory(lib.getDependentCategories()).keySet()) {
                ClientLibraryImpl dep = this.resolveLib(processed, depPath);
                if (dep == null) continue;
                lib.addDependency(dep);
            }
            for (String depPath : this.getLibsByCategory(lib.getEmbeddedCategories()).keySet()) {
                ClientLibraryImpl dep = this.resolveLib(processed, depPath);
                if (dep == null) continue;
                lib.addEmbedded(dep);
            }
        }
        return lib;
    }

    private Map<String, ClientLibrary> lockedGetLibs(String[] categories, LibraryType type, Boolean themed, String themeName, boolean transitive) {
        this.assertResolved();
        if ("".equals(themeName)) {
            themeName = this.defaultThemeName;
        }
        LinkedHashMap<String, ClientLibrary> candidates = new LinkedHashMap<String, ClientLibrary>();
        for (ClientLibraryImpl lib : this.getLibsByCategory(categories).values()) {
            if (transitive) {
                candidates.putAll(lib.getDependencies(true));
            }
            candidates.put(lib.getPath(), lib);
        }
        HashSet<String> embedded = new HashSet<String>();
        Iterator iter = candidates.values().iterator();
        while (iter.hasNext()) {
            ClientLibrary lib = (ClientLibrary)iter.next();
            if (type != null && !lib.getTypes().contains((Object)type)) {
                iter.remove();
                continue;
            }
            if (themed != null && !themed.booleanValue() && lib.getThemeName() != null) {
                iter.remove();
                continue;
            }
            if (themed != null && themed.booleanValue() && lib.getThemeName() == null) {
                iter.remove();
                continue;
            }
            embedded.addAll(lib.getEmbedded(null).keySet());
        }
        candidates.keySet().removeAll(embedded);
        if (themed == null || themed.booleanValue()) {
            LinkedHashMap<String, ClientLibrary> ret = new LinkedHashMap<String, ClientLibrary>();
            Iterator iter2 = candidates.values().iterator();
            while (iter2.hasNext()) {
                ClientLibrary lib = (ClientLibrary)iter2.next();
                if (lib.getThemeName() != null) continue;
                ret.put(lib.getPath(), lib);
                iter2.remove();
            }
            if (themeName != null && themeName.equals(this.defaultThemeName)) {
                ret.putAll(candidates);
            } else {
                for (ClientLibrary lib : candidates.values()) {
                    if (!this.defaultThemeName.equals(lib.getThemeName())) continue;
                    ret.put(lib.getThemeLibId(), lib);
                }
                for (ClientLibrary lib : candidates.values()) {
                    if (this.defaultThemeName.equals(lib.getThemeName())) continue;
                    ret.put(lib.getThemeLibId(), lib);
                }
            }
            candidates = ret;
        }
        return candidates;
    }

    private Map<String, ClientLibraryImpl> getLibsByCategory(String[] categories) {
        LinkedHashMap<String, ClientLibraryImpl> entries = new LinkedHashMap<String, ClientLibraryImpl>();
        for (String category : categories) {
            Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(category);
            if (libs == null) continue;
            for (ClientLibraryImpl e : libs.values()) {
                if (entries.containsKey(e.getPath())) continue;
                entries.put(e.getPath(), e);
            }
        }
        return entries;
    }

    private void loadLibs() throws RepositoryException {
        this.libsByCategory.clear();
        this.libsByPath.clear();
        String queryString = "/jcr:root//element(*, cq:ClientLibraryFolder)";
        Query query = this.admin.getWorkspace().getQueryManager().createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        while (itr.hasNext()) {
            Node n = itr.nextNode();
            if (this.isPathAllowed(n.getPath())) {
                this.loadLibrary(n, false);
                continue;
            }
            this.log.debug("Client Library {} excluded because it is not in an allowed path.", (Object)n.getPath());
        }
    }

    private boolean isPathAllowed(String path) {
        for (String allowedPath : this.allowedPaths) {
            if ("".equals(allowedPath) || !Text.isDescendantOrEqual((String)allowedPath, (String)path)) continue;
            return true;
        }
        return false;
    }

    private void loadLibrary(Node n, boolean forceRecreate) throws RepositoryException {
        JcrPropertyMap props = new JcrPropertyMap(n);
        String path = n.getPath();
        String ext = "";
        boolean isLegacy = false;
        int idx = path.lastIndexOf(46);
        if (idx > 0) {
            ext = path.substring(idx + 1);
        }
        if (ext.equals(JS) || ext.equals(CSS)) {
            isLegacy = true;
        } else {
            ext = "";
        }
        String type = (String)props.get("type", (Object)ext);
        EnumSet<LibraryType> types = EnumSet.noneOf(LibraryType.class);
        if (n.hasNode("js.txt") || JS.equals(type)) {
            types.add(LibraryType.JS);
        }
        if (n.hasNode("css.txt") || CSS.equals(type)) {
            types.add(LibraryType.CSS);
        }
        if (types.isEmpty()) {
            this.log.debug("Client Library {} does not specify a type.", (Object)path);
        }
        String theme = null;
        String libId = path;
        if (n.getParent().getName().equals("themes")) {
            theme = n.getName();
            libId = n.getParent().getPath();
        }
        String[] categories = (String[])props.get(PN_CATEGORIES, (Object)EMPTY_STRING_ARRAY);
        String[] dependencies = (String[])props.get(PN_DEPENDENCIES, (Object)EMPTY_STRING_ARRAY);
        String[] embeds = (String[])props.get(PN_EMBED, (Object)EMPTY_STRING_ARRAY);
        String[] pChannels = (String[])props.get(PN_CHANNELS, (Object)EMPTY_STRING_ARRAY);
        ClientLibraryImpl entry = new ClientLibraryImpl(path, categories, dependencies, embeds, pChannels, isLegacy, theme, libId);
        for (LibraryType t : types) {
            FileBundle bundle = isLegacy ? new FileBundle(n, path, INCLUDES_TXT, "/files") : new FileBundle(n, path + t.extension, t.name().toLowerCase() + ".txt", "");
            bundle.setDirty(forceRecreate);
            entry.addBundle(t, bundle);
        }
        this.libsByPath.put(path, entry);
        if (theme == null) {
            this.log.info("detected {} library: {}", types, (Object)path);
        } else {
            this.log.info("detected {} theme library: {}", types, (Object)path);
        }
        for (String category : categories) {
            this.log.debug("assigned category {}", (Object)category);
            Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(category);
            if (libs == null) {
                libs = new TreeMap<String, ClientLibraryImpl>(REV_PATH_COMPARATOR);
                this.libsByCategory.put(category, libs);
            }
            libs.put(path, entry);
        }
    }

    private void invalidate(String path) {
        ClientLibraryImpl e = this.libsByPath.remove(path);
        if (e != null) {
            this.log.info("Invalidating library {}", (Object)path);
            for (String tag : e.getCategories()) {
                Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(tag);
                if (libs == null) continue;
                libs.remove(path);
            }
        }
        try {
            Node node;
            if (this.admin.itemExists(path) && (node = (Node)this.admin.getItem(path)).isNodeType(CQ_CLIENT_LIBRARY_FOLDER)) {
                this.loadLibrary(node, true);
            }
        }
        catch (RepositoryException e1) {
            this.log.error("Error while loading library {}", (Object)path);
        }
        this.isResolved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastModified(HtmlLibraryImpl lib) {
        this.lock.readLock().lock();
        try {
            long l = this.getCacheNode(lib).getProperty("jcr:lastModified").getLong();
            return l;
        }
        catch (RepositoryException e) {
            this.log.error("Error occurred while reading the last modified date of the generated library");
            long l = -1L;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(HtmlLibraryImpl lib, HttpServletResponse response, boolean gzip) throws IOException {
        Binary binary;
        InputStream is;
        block11: {
            is = null;
            binary = null;
            try {
                this.lock.readLock().lock();
                try {
                    Node node = this.getCacheNode(lib);
                    response.setDateHeader("Last-Modified", node.getProperty("jcr:lastModified").getLong());
                    response.setContentType(node.getProperty("jcr:mimeType").getString());
                    binary = node.getProperty("jcr:data").getBinary();
                    is = binary.getStream();
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (gzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    IOUtils.copy((InputStream)is, (OutputStream)gzipOut);
                    gzipOut.finish();
                    break block11;
                }
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            }
            catch (RepositoryException e) {
                try {
                    this.log.error("Error while sending cached library: {}", (Object)e.toString());
                    throw new IOException("Error while sending cached library: " + (Object)((Object)e));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    if (binary != null) {
                        binary.dispose();
                    }
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        if (binary != null) {
            binary.dispose();
        }
    }

    protected InputStream getInputStream(HtmlLibraryImpl lib) throws IOException {
        this.lock.readLock().lock();
        try {
            InputStream inputStream = this.getCacheNode(lib).getProperty("jcr:data").getBinary().getStream();
            return inputStream;
        }
        catch (RepositoryException e) {
            this.log.error("Cannot read input stream", (Throwable)e);
            throw new IOException("Error while reading cached library: " + (Object)((Object)e));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Node getCacheNode(HtmlLibraryImpl lib) throws RepositoryException {
        boolean inWriteLock = false;
        try {
            Node node;
            String path = lib.getPath() + "/" + "jcr:content";
            if (this.admin.itemExists(path)) {
                node = (Node)this.admin.getItem(path);
            } else {
                String parentPath = Text.getRelativeParent((String)lib.getPath(), (int)1);
                String name = Text.getName((String)lib.getPath());
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                inWriteLock = true;
                Node tmpLocation = JcrUtil.createPath((String)(TMP_LOCATION + parentPath), (String)"sling:Folder", (String)"sling:Folder", (Session)this.admin, (boolean)true);
                if (tmpLocation.hasNode(name)) {
                    node = tmpLocation.getNode(name + "/" + "jcr:content");
                } else {
                    Node fileNode = tmpLocation.addNode(name, "nt:file");
                    node = fileNode.addNode("jcr:content", "nt:resource");
                    node.setProperty("jcr:data", node.getSession().getValueFactory().createBinary((InputStream)new ByteArrayInputStream(new byte[0])));
                    node.setProperty("jcr:lastModified", 0L);
                    node.setProperty("jcr:mimeType", lib.getType().contentType);
                    this.admin.save();
                }
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
                inWriteLock = false;
            }
            if (lib.getBundle().isDirty() || lib.getBundleLastModified() > node.getProperty("jcr:lastModified").getLong()) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                inWriteLock = true;
                this.update(lib, node);
                this.admin.save();
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
                inWriteLock = false;
            }
            Node node2 = node;
            return node2;
        }
        catch (RepositoryException e) {
            this.log.error("Error while saving changes: {}. reverting.", (Object)e.toString());
            try {
                this.admin.refresh(false);
            }
            catch (RepositoryException e1) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (inWriteLock) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(HtmlLibraryImpl lib, Node node) throws RepositoryException {
        this.log.info("Start building {} library: {}", (Object)lib.getType(), (Object)lib.getLibraryPath());
        File file = null;
        try {
            FileInputStream in;
            Session session = node.getSession();
            Resources resources = new Resources();
            FileBundle[] embedded = lib.getEmbedded();
            if (embedded != null && embedded.length > 0) {
                for (FileBundle bundle : embedded) {
                    bundle.addResources(session, lib.getLibraryPath(), resources);
                }
            }
            lib.getBundle().addResources(session, lib.getLibraryPath(), resources);
            long lastMod = lib.getBundleLastModified();
            AbstractBuilder builder = lib.getType() == LibraryType.JS ? new JsFileBuilder() : new CssFileBuilder(Text.getName((String)lib.getLibraryPath()));
            builder.setDoMinify(this.enableMinify);
            try {
                file = builder.build(resources);
                in = new FileInputStream(file);
            }
            catch (Exception e) {
                this.log.error("Error during assembly of library.", (Throwable)e);
                throw new RepositoryException("Error during assembly of " + lib.getPath(), (Throwable)e);
            }
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lastMod);
                node.setProperty("jcr:data", (InputStream)in);
                node.setProperty("jcr:lastModified", cal);
                node.setProperty("jcr:mimeType", lib.getType().contentType);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            lib.getBundle().setDirty(false);
        }
        finally {
            if (file != null && !file.delete()) {
                this.log.warn("Deletion of tmp file at '{}' was not successful.", (Object)file.getPath());
            }
        }
        this.log.info("finished building library {}", (Object)lib.getPath());
    }

    private String getDefaultThemeName(SlingHttpServletRequest request) {
        String theme = request.getParameter("forceTheme");
        if (theme == null) {
            theme = this.defaultUserThemeName;
        }
        return theme;
    }

    private Set<String> getIncludedSet(SlingHttpServletRequest request) {
        HashSet set = (HashSet)request.getAttribute(INCLUDED_SET_ATTR_NAME);
        if (set == null) {
            set = new HashSet();
            request.setAttribute(INCLUDED_SET_ATTR_NAME, set);
        }
        return set;
    }

    private boolean isIncluded(SlingHttpServletRequest request, String path) {
        if (path == null) {
            return true;
        }
        Set<String> set = this.getIncludedSet(request);
        if (set.contains(path)) {
            return true;
        }
        set.add(path);
        return false;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

