/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import com.day.cq.widget.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlLibraryServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(HtmlLibraryServlet.class);
    private static final String DEBUG = "debug";
    private static final int MAX_CSS_FILES_TO_INCLUDE = 31;
    protected HtmlLibraryManager libMgr;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        try {
            HtmlLibrary library = this.libMgr.getLibrary(request);
            if (library == null) {
                response.sendError(404);
                return;
            }
            if (this.isDebug(request)) {
                log.debug("Creating {} debug library for {}", (Object)library.getType(), (Object)library.getLibraryPath());
                if (library.getType() == LibraryType.JS) {
                    this.createJsDebugScript(library, request, response);
                } else {
                    this.createCssDebugScript(library, request, response);
                }
                log.debug("Created {} debug library for {}", (Object)library.getType(), (Object)library.getLibraryPath());
            } else if (this.unmodified(request, library.getLastModified())) {
                response.setStatus(304);
            } else {
                library.send((HttpServletResponse)response, this.libMgr.isGzipEnabled());
            }
        }
        catch (Exception e) {
            log.error("Cannot create library for {}", (Object)request.getRequestURI(), (Object)e);
            response.sendError(404);
        }
    }

    private boolean isDebug(SlingHttpServletRequest request) {
        return "true".equals(request.getParameter(DEBUG));
    }

    protected String getLoaderScript() throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/day/cq/widget/Loader.js");
        return IOUtils.toString((InputStream)is);
    }

    protected void createJsDebugScript(HtmlLibrary library, SlingHttpServletRequest request, SlingHttpServletResponse response) throws Exception {
        response.setContentType("application/x-javascript");
        String scriptList = library.getScripts("\n,");
        String loaderScript = this.getLoaderScript();
        loaderScript = loaderScript.replaceAll("__JS_FILES__", scriptList);
        loaderScript = loaderScript.replaceAll("__RESOURCE_PATH__", request.getContextPath());
        response.getWriter().write(loaderScript);
    }

    protected void createCssDebugScript(HtmlLibrary library, SlingHttpServletRequest request, SlingHttpServletResponse response) throws Exception {
        response.setContentType(library.getType().contentType);
        List<String> cssFiles = library.getScripts();
        if (cssFiles.size() > 31 && request.getRequestPathInfo().getSelectors().length == 0) {
            int slices = cssFiles.size() / 31;
            ServletOutputStream out = response.getOutputStream();
            for (int i = 0; i <= slices; ++i) {
                int slice = i * 31;
                out.println("@import url(\"" + request.getContextPath() + library.getLibraryPath() + "." + slice + ".css?debug=true\");");
            }
        } else {
            int offset = 0;
            if (request.getRequestPathInfo().getSelectors().length > 0) {
                offset = Integer.valueOf(request.getRequestPathInfo().getSelectors()[0]);
            }
            int len = Math.min(cssFiles.size(), offset + 31);
            for (int i = offset; i < len; ++i) {
                String cssFile = cssFiles.get(i);
                response.getOutputStream().println("@import url(\"" + request.getContextPath() + cssFile + "\");");
            }
            log.debug("Included from " + offset + " to " + len);
        }
    }

    private boolean unmodified(SlingHttpServletRequest request, long modifTime) {
        if (modifTime > 0L) {
            long modTime = modifTime / 1000L;
            long ims = request.getDateHeader("If-Modified-Since") / 1000L;
            return modTime <= ims;
        }
        return false;
    }

    protected void bindLibMgr(HtmlLibraryManager htmlLibraryManager) {
        this.libMgr = htmlLibraryManager;
    }

    protected void unbindLibMgr(HtmlLibraryManager htmlLibraryManager) {
        if (this.libMgr == htmlLibraryManager) {
            this.libMgr = null;
        }
    }
}

