/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.tools.ant.types.Resource;

public class JcrPropertyResource
extends Resource {
    private final Property data;
    private final int relDepth;
    private InputStream stream;

    public JcrPropertyResource(Property data, String name, int relDepth) {
        super(name);
        this.relDepth = relDepth;
        this.data = data;
    }

    public int getRelDepth() {
        return this.relDepth;
    }

    public boolean isExists() {
        return true;
    }

    public synchronized long getSize() {
        try {
            return this.data.getLength();
        }
        catch (RepositoryException e) {
            return -1L;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.stream == null) {
            try {
                this.stream = this.data.getBinary().getStream();
            }
            catch (RepositoryException e) {
                IOException io = new IOException("Unable to provide data stream.");
                io.initCause(e);
                throw io;
            }
        }
        return this.stream;
    }
}

