/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.AbstractBuilder;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.tools.ant.taskdefs.Concat;
import org.apache.tools.ant.taskdefs.optional.ReplaceRegExp;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsFileBuilder
extends AbstractBuilder {
    private static final Logger log = LoggerFactory.getLogger(JsFileBuilder.class);
    private static final int lineBreakPos = 0;
    private static final boolean warn = false;
    private static final boolean munge = true;
    private static final boolean preserveAllSemiColons = false;
    private static final boolean disableOptimizationsOpt = false;
    private static final boolean contactFixLastLine = true;

    protected File concatenate(Resources coll) throws IOException {
        Concat concat = new Concat();
        concat.add((ResourceCollection)coll);
        File dest = File.createTempFile("jsfile", ".js");
        concat.setDestfile(dest);
        concat.setFixLastLine(true);
        concat.setAppend(false);
        concat.execute();
        ReplaceRegExp repl = new ReplaceRegExp();
        repl.setFile(dest);
        repl.setMatch("CQ\\.Log\\.[fatal|error|warn|info|debug|trace|i18n]\\(.*\\)\\;");
        repl.setReplace("");
        repl.setFlags("g");
        return dest;
    }

    protected void minify(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)isr, new ErrorReporter(){

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (line < 0) {
                    log.debug("\n[WARNING] " + message);
                } else {
                    log.debug("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
                }
            }

            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (line < 0) {
                    log.error("\n[ERROR] " + message);
                } else {
                    log.error("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
                }
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                this.error(message, sourceName, line, lineSource, lineOffset);
                return new EvaluatorException(message);
            }
        });
        inputStream.close();
        OutputStreamWriter out = new OutputStreamWriter(outputStream, "utf-8");
        compressor.compress((Writer)out, 0, true, false, false, false);
        out.close();
    }

    public LibraryType getType() {
        return LibraryType.JS;
    }
}

