/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.servlets;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.json.io.JSONWriter;

public class ExtMediaListServlet
extends AbstractPredicateServlet {
    private static final long serialVersionUID = 3455838419967710845L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            PrintWriter out = response.getWriter();
            JSONWriter writer = new JSONWriter((Writer)out);
            writer.object();
            writer.key("items");
            writer.array();
            Node node = (Node)request.getResource().adaptTo(Node.class);
            if (node != null) {
                NodeIterator iter = node.getNodes();
                while (iter.hasNext()) {
                    String name;
                    Node child = iter.nextNode();
                    if (!child.isNodeType("nt:file") || (name = child.getName()).equals(".DS_Store") || name.startsWith("._")) continue;
                    Node content = child.getNode("jcr:content");
                    String type = content.getProperty("jcr:mimeType").getString();
                    String ddGroup = "file";
                    if (type.startsWith("image/")) {
                        ddGroup = "image";
                    }
                    writer.object();
                    writer.key("name").value((Object)name);
                    writer.key("size").value(content.getProperty("jcr:data").getLength());
                    writer.key("created").value(child.getProperty("jcr:created").getLong());
                    writer.key("lastmod").value(content.getProperty("jcr:lastModified").getLong());
                    writer.key("path").value((Object)child.getPath());
                    writer.key("ddGroup").value((Object)ddGroup);
                    writer.key("mimetype").value((Object)type);
                    writer.endObject();
                }
            }
            writer.endArray();
            writer.endObject();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

