/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

// make Loader class private, ie. define, execute and forget,
// in order to load multiple Loader.js on the same page without conflicts
(function() {
    
    /**
     * The <code>Loader</code> class loads all CQ depending js sources.
     * Sample how to include the Loader in an HTML document:
     * @class
     * @param {String} resourcePath The resource path
     */
    var Loader = function(resourcePath) {
    
        /** @type String */
        Loader.resourcePath = resourcePath ? resourcePath : "";
    
    };
    
    /**
     * Gets a page from a URL and returns the response.
     * @static
     * @private
     * @param {String} url The URL
     * @return The response
     * @type String
     */
    Loader.get = function(url) {
        var httpcon = document.all ?
            new ActiveXObject("Microsoft.XMLHTTP") : new XMLHttpRequest();
        if (httpcon) {
            try {
                httpcon.open('GET', url, false);
                httpcon.send(null);
                return httpcon.responseText;
            }
            catch (e) {
                return "";
            }
        } else {
        	return "";
        }
    };

    /**
     * Checks if the content returned by a request to <code>url</code> is empty.
     * @static
     * @private
     * @param {String} url The url to verify
     * @return {Boolean} True if empty file at given url. False otherwise.
     * @type Boolean
     */
    Loader.isEmpty = function(url) {
        var responseText = Loader.get(url);
        responseText = responseText.replace(new RegExp("\\s", "ig"),"");
        return responseText.length == 0;
    };
    
    /**
     * JavaScript to load
     * @private
     * @final
     * @type String[]
     */
    Loader.js =  [ __JS_FILES__ ];
    
    /**
     * Sets the path where the sources will be loaded from.
     * @param {String} path The path
     */
    Loader.prototype.setResourcePath = function(path) {
        Loader.resourcePath = path;
    };
    
    /**
     * Loads the javascript sources.
     * @private
     */
    Loader.prototype.draw = function() {
        this.createScriptElements(Loader.resourcePath, Loader.js);
    };

    /**
     * Creates the script elements to load the javascript sources.
     * @private
     * @param {String} path The path
     * @param {String[]} sources The sources
     */
    Loader.prototype.createScriptElements = function(path, sources) {
        for (var elem in sources) {
            // we don't want to request the "remove" function
            if (!sources.hasOwnProperty(elem)) continue;
            
            var url = path + sources[elem];
    
            if (document.all || window.navigator.appVersion.indexOf("Safari") >= 0) {
    //             check if script exists to avoid errors in IE
                if (Loader.isEmpty(url)) {
                    continue;
                }
            }
            // make sure that the link rewriter does not touch the script string
            var scriptStr = "\<scri";
            scriptStr += "pt type='text/javascript' sr";
            scriptStr += "c='" + url + "'>\</sc";
            scriptStr += "ript>";
            document.write(scriptStr);
        }
    };
    
    new Loader("__RESOURCE_PATH__").draw();

})();