/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.xss.impl;

import com.day.cq.xss.EscapingRule;
import com.day.cq.xss.ProtectionContext;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import com.day.cq.xss.impl.rules.HtmlToHtmlContent;
import com.day.cq.xss.impl.rules.PlainTextToHtmlContent;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;

public class XSSProtectionServiceImpl
implements XSSProtectionService {
    private static final String REL_PATH_PREFIXES = "xssprotection.prefixes";
    private String[] relPathPrefixes;
    private SlingRepository repository;
    private final Map<ProtectionContext, EscapingRule> rules = new HashMap<ProtectionContext, EscapingRule>();

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.relPathPrefixes = (String[])props.get(REL_PATH_PREFIXES);
        int prefix = 0;
        for (String strToCheck : this.relPathPrefixes) {
            String adaptedPath = strToCheck;
            if (!adaptedPath.startsWith("/")) {
                adaptedPath = "/" + adaptedPath;
            }
            if (adaptedPath.endsWith("/")) {
                adaptedPath = adaptedPath.substring(0, adaptedPath.length() - 1);
            }
            if (adaptedPath != strToCheck) {
                this.relPathPrefixes[prefix] = adaptedPath;
            }
            ++prefix;
        }
        this.rules.clear();
        this.rules.put(ProtectionContext.HTML_HTML_CONTENT, new HtmlToHtmlContent());
        this.rules.put(ProtectionContext.PLAIN_HTML_CONTENT, new PlainTextToHtmlContent());
    }

    public synchronized void invalidatePolicy(String policyPath) {
        ((HtmlToHtmlContent)this.rules.get((Object)ProtectionContext.HTML_HTML_CONTENT)).invalidatePolicy(policyPath, this.relPathPrefixes, this.repository);
    }

    public String protectFromXSS(String src) throws XSSProtectionException {
        return this.protectForContext(ProtectionContext.HTML_HTML_CONTENT, src);
    }

    public String protectFromXSS(String src, String policyPath) throws XSSProtectionException {
        return this.protectForContext(ProtectionContext.HTML_HTML_CONTENT, src, policyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String protectForContext(ProtectionContext context, String src, String policyPath) throws XSSProtectionException {
        EscapingRule rule = this.rules.get((Object)context);
        XSSProtectionServiceImpl xSSProtectionServiceImpl = this;
        synchronized (xSSProtectionServiceImpl) {
            rule.configure(policyPath, this.relPathPrefixes, this.repository);
            return rule.escape(src);
        }
    }

    public String protectForContext(ProtectionContext context, String src) throws XSSProtectionException {
        return this.protectForContext(context, src, null);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

