/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.xss.impl.rules;

import com.day.cq.xss.EscapingRule;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.impl.util.CachedObjHelpers;
import com.day.cq.xss.impl.util.CachedObjWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.map.LRUMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContent
implements EscapingRule {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_POLICY_PATH = "cq/xssprotection/config.xml";
    private static final int DEFAULT_POLICY_CACHE_SIZE = 128;
    private Map<String, CachedObjWrapper> policyCache;
    private Policy policyToUse;

    private String resolveRelativePath(String relPath, String[] relPathPrefixes, Session session) throws RepositoryException {
        if (relPath.charAt(0) == '/') {
            return relPath;
        }
        Node root = session.getRootNode();
        String resolvedPath = null;
        for (String prefix : relPathPrefixes) {
            String pathToTest = prefix + "/" + relPath;
            if (root.hasNode(pathToTest.substring(1))) {
                resolvedPath = pathToTest;
                this.log.debug("Relative policy path '{}' resolved to '{}'", (Object)relPath, (Object)resolvedPath);
                break;
            }
            if (!this.policyCache.containsKey(pathToTest)) continue;
            this.policyCache.remove(pathToTest);
            this.log.debug("Removed policy '{}' from cache; policy node has been removed.", (Object)pathToTest);
        }
        return resolvedPath;
    }

    private Node getPolicyNode(Node root, String absNodePath) throws RepositoryException {
        Node policyNode = root.getNode(absNodePath.substring(1));
        if (policyNode.isNodeType("nt:file")) {
            policyNode = policyNode.getNode("jcr:content");
        }
        return policyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CachedObjWrapper loadPolicy(String nodePath, Session session) throws PolicyException, RepositoryException, XSSProtectionException {
        Policy policy;
        if (nodePath == null) {
            nodePath = DEFAULT_POLICY_PATH;
        }
        Node root = session.getRootNode();
        String absNodePath = nodePath;
        Node policyNode = this.getPolicyNode(root, absNodePath);
        this.log.debug("Loading policy from '{}'.", (Object)policyNode.getPath());
        Property prop = policyNode.getProperty("jcr:data");
        Long modified = CachedObjHelpers.getModified(policyNode);
        InputStream policyStream = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            policyStream = prop.getStream();
            policy = Policy.getInstance(policyStream);
        }
        finally {
            if (policyStream != null) {
                try {
                    policyStream.close();
                }
                catch (IOException ioe) {}
            }
            currentThread.setContextClassLoader(cl);
        }
        return new CachedObjWrapper(policy, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePolicy(String policyPath, String[] relPathPrefixes, SlingRepository repository) {
        if (policyPath == null) {
            policyPath = DEFAULT_POLICY_PATH;
        }
        if (this.policyCache != null) {
            if (!policyPath.startsWith("/")) {
                Session session = null;
                try {
                    session = repository.loginAdministrative(null);
                    policyPath = this.resolveRelativePath(policyPath, relPathPrefixes, session);
                }
                catch (RepositoryException re) {
                    this.log.debug("Could not resolve path '{}' for invalidating cache.", (Object)policyPath);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            if (this.policyCache.remove(policyPath) != null) {
                this.log.debug("Policy '{}' removed from policy cache.", (Object)policyPath);
            }
        }
    }

    public void configure(String policyPath, String[] relPathPrefixes, SlingRepository repository) throws XSSProtectionException {
        if (policyPath == null) {
            policyPath = DEFAULT_POLICY_PATH;
        }
        if (policyPath.length() == 0) {
            throw new IllegalArgumentException("Invalid policy path.");
        }
        this.policyToUse = null;
        Session session = null;
        try {
            String absPath;
            session = repository.loginAdministrative(null);
            if (this.policyCache == null) {
                this.policyCache = new LRUMap(128);
            }
            if ((absPath = this.resolveRelativePath(policyPath, relPathPrefixes, session)) == null) {
                throw new XSSProtectionException("Could not resolve '" + policyPath + " to a valid policy node.");
            }
            CachedObjWrapper cachedPolicy = this.policyCache.get(absPath);
            if (cachedPolicy == null) {
                this.log.debug("Policy '{}' not yet cached; loading from repository.", (Object)absPath);
                cachedPolicy = this.loadPolicy(absPath, session);
                this.policyCache.put(absPath, cachedPolicy);
            } else {
                Node policyNode = this.getPolicyNode(session.getRootNode(), absPath);
                Long modified = CachedObjHelpers.getModified(policyNode);
                if (cachedPolicy.isModified(modified)) {
                    this.log.debug("Cached policy '{}' invalidated; reloading.", (Object)absPath);
                    cachedPolicy = this.loadPolicy(absPath, session);
                    this.policyCache.put(absPath, cachedPolicy);
                } else {
                    this.log.debug("Taking policy '{}' from cache.", (Object)absPath);
                }
            }
            this.policyToUse = (Policy)cachedPolicy.getCachedObject();
        }
        catch (RepositoryException re) {
            throw new XSSProtectionException("Could not load XSS policy from repository.", re);
        }
        catch (PolicyException pe) {
            throw new XSSProtectionException("Could not parse policy for path '" + policyPath + "'.", pe);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String escape(String str) throws XSSProtectionException {
        if (this.policyToUse == null) {
            throw new XSSProtectionException("No policy available. Please check log for preceding errors.");
        }
        try {
            this.log.debug("Protecting (HTML -> HTML) :\n{}", (Object)str);
            AntiSamy antiSamyInstance = new AntiSamy(this.policyToUse);
            CleanResults results = antiSamyInstance.scan(str);
            String cleaned = results.getCleanHTML();
            ArrayList errors = results.getErrorMessages();
            for (String error : errors) {
                this.log.info("AntiSamy warning: {}", (Object)error);
            }
            this.log.debug("Protected (HTML -> HTML):\n{}", (Object)cleaned);
            return cleaned;
        }
        catch (ScanException se) {
            throw new XSSProtectionException("Error while scanning string for preventing XSS.", se);
        }
        catch (PolicyException pe) {
            throw new XSSProtectionException("Policy related error while preventing XSS.", pe);
        }
    }
}

