/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.xss.impl.rules;

import com.day.cq.xss.EscapingRule;
import com.day.cq.xss.XSSProtectionException;
import org.apache.sling.jcr.api.SlingRepository;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextToHtmlContent
implements EscapingRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void configure(String policyPath, String[] relPathPrefixes, SlingRepository repository) throws XSSProtectionException {
        if (policyPath != null) {
            this.log.info("The plain text to HTML rule doesn't use a policy file; ignoring '{}'", (Object)policyPath);
        }
    }

    public String escape(String str) throws XSSProtectionException {
        this.log.debug("Protecting (plain text -> HTML) :\n{}", (Object)str);
        String cleaned = HTMLEntityEncoder.htmlEntityEncode(str);
        this.log.debug("Protected (plain text -> HTML) :\n{}", (Object)cleaned);
        return cleaned;
    }
}

