/*
 * Decompiled with CFR 0.152.
 */
package info.dmtree.security;

import info.dmtree.Uri;
import info.dmtree.security.DmtPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public class DmtPermission
extends Permission {
    private static final long serialVersionUID = -1910969921419407809L;
    public static final String ADD = "Add";
    public static final String DELETE = "Delete";
    public static final String EXEC = "Exec";
    public static final String GET = "Get";
    public static final String REPLACE = "Replace";
    private final boolean prefixPath;
    private final String path;
    private final int mask;
    private final String actions;

    public DmtPermission(String dmtUri, String actions) {
        super(dmtUri);
        this.mask = DmtPermission.getMask(actions);
        this.actions = DmtPermission.canonicalActions(this.mask);
        if (dmtUri == null) {
            throw new NullPointerException("'dmtUri' parameter must not be null.");
        }
        boolean bl = this.prefixPath = dmtUri.endsWith("*") && !dmtUri.endsWith("\\*");
        if (this.prefixPath && (dmtUri = dmtUri.substring(0, dmtUri.length() - 1)).length() == 0) {
            this.path = "";
            return;
        }
        if (this.prefixPath && dmtUri.endsWith("/") && !dmtUri.endsWith("\\/")) {
            this.checkUri(dmtUri.substring(0, dmtUri.length() - 1));
        } else {
            this.checkUri(dmtUri);
        }
        StringBuffer sb = new StringBuffer(dmtUri);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            char nextCh = sb.charAt(i + 1);
            if (nextCh != '/' && nextCh != '\\') {
                sb.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        this.path = ((Object)sb).toString();
    }

    private void checkUri(String dmtUri) throws IllegalArgumentException {
        if (!Uri.isValidUri(dmtUri)) {
            throw new IllegalArgumentException("'dmtUri' parameter does not contain a valid URI.");
        }
        if (!Uri.isAbsoluteUri(dmtUri)) {
            throw new IllegalArgumentException("'dmtUri' parameter does not contain an absolute URI.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DmtPermission)) {
            return false;
        }
        DmtPermission other = (DmtPermission)obj;
        return this.mask == other.mask && this.prefixPath == other.prefixPath && this.path.equals(other.path);
    }

    public String getActions() {
        return this.actions;
    }

    public int hashCode() {
        return ((Object)new Integer(this.mask)).hashCode() ^ ((Object)new Boolean(this.prefixPath)).hashCode() ^ this.path.hashCode();
    }

    public boolean implies(Permission p) {
        if (!(p instanceof DmtPermission)) {
            return false;
        }
        DmtPermission other = (DmtPermission)p;
        if ((this.mask & other.mask) != other.mask) {
            return false;
        }
        return this.impliesPath(other);
    }

    public PermissionCollection newPermissionCollection() {
        return new DmtPermissionCollection();
    }

    private static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            throw new NullPointerException("'actions' parameter cannot be null.");
        }
        if (actions.equals("*")) {
            return 31;
        }
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String action = st.nextToken();
            if (action.equalsIgnoreCase(GET)) {
                mask |= 1;
                continue;
            }
            if (action.equalsIgnoreCase(ADD)) {
                mask |= 2;
                continue;
            }
            if (action.equalsIgnoreCase(REPLACE)) {
                mask |= 4;
                continue;
            }
            if (action.equalsIgnoreCase(DELETE)) {
                mask |= 8;
                continue;
            }
            if (action.equalsIgnoreCase(EXEC)) {
                mask |= 0x10;
                continue;
            }
            throw new IllegalArgumentException("Invalid action '" + action + "'");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("Action mask cannot be empty.");
        }
        return mask;
    }

    private static String canonicalActions(int mask) {
        StringBuffer sb = new StringBuffer();
        DmtPermission.addAction(sb, mask, 2, ADD);
        DmtPermission.addAction(sb, mask, 8, DELETE);
        DmtPermission.addAction(sb, mask, 16, EXEC);
        DmtPermission.addAction(sb, mask, 1, GET);
        DmtPermission.addAction(sb, mask, 4, REPLACE);
        return ((Object)sb).toString();
    }

    private static void addAction(StringBuffer sb, int mask, int flag, String action) {
        if ((mask & flag) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(action);
        }
    }

    int getMask() {
        return this.mask;
    }

    boolean impliesPath(DmtPermission p) {
        return this.prefixPath ? p.path.startsWith(this.path) : !p.prefixPath && p.path.equals(this.path);
    }
}

