/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.thumbnail;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.thumbnail.ThumbnailConfigImpl;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.OrientationUtil;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailGenerator {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailGenerator.class);
    private final Asset asset;
    private final BufferedImage image;

    public ThumbnailGenerator(Asset asset, BufferedImage image) {
        this.asset = asset;
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Collection<ThumbnailConfig> configs) throws IOException, RepositoryException {
        File tmpFile = null;
        boolean oldBatchMode = this.asset.isBatchMode();
        this.asset.setBatchMode(true);
        try {
            tmpFile = File.createTempFile("thumbnail", ".tmp");
            ArrayList<ThumbnailConfig> cfg = new ArrayList<ThumbnailConfig>(configs);
            Collections.sort(cfg, new Comparator<ThumbnailConfig>(){

                @Override
                public int compare(ThumbnailConfig o1, ThumbnailConfig o2) {
                    if (o1.getWidth() == o2.getWidth()) {
                        return o2.getHeight() - o1.getHeight();
                    }
                    return o2.getWidth() - o1.getWidth();
                }
            });
            Layer layer = null;
            for (ThumbnailConfig config : cfg) {
                if (layer == null || config.getWidth() > layer.getWidth() || config.getHeight() > layer.getHeight()) {
                    if (layer != null) {
                        layer.dispose();
                    }
                    layer = new Layer(this.image);
                    if (OrientationUtil.hasOrientationMetadata(this.asset)) {
                        OrientationUtil.adjustOrientation(this.asset, layer);
                    }
                }
                Layer tLayer = this.createThumbnail(layer, config);
                FileOutputStream out = null;
                FileInputStream in = null;
                try {
                    out = FileUtils.openOutputStream((File)tmpFile);
                    tLayer.write("image/png", 0.8, (OutputStream)out);
                    IOUtils.closeQuietly((OutputStream)out);
                    in = FileUtils.openInputStream((File)tmpFile);
                    this.asset.addRendition(DamUtil.getThumbnailName(config), (InputStream)in, "image/png");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly((OutputStream)out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                if (tLayer == layer) continue;
                tLayer.dispose();
            }
            try {
                if (!this.asset.isBatchMode()) {
                    ((Node)this.asset.adaptTo(Node.class)).getSession().save();
                }
            }
            catch (RepositoryException e) {
                String msg = "generate: error while saving changes for asset [" + this.asset.getPath() + "]: ";
                log.debug(msg, (Throwable)e);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        finally {
            this.asset.setBatchMode(oldBatchMode);
            FileUtils.deleteQuietly((File)tmpFile);
        }
    }

    public static Collection<ThumbnailConfig> parseConfig(String[] args) {
        HashSet<ThumbnailConfig> configs = new HashSet<ThumbnailConfig>();
        for (String arg : args) {
            ThumbnailConfig config = ThumbnailGenerator.parseConfig(arg);
            if (null == config) continue;
            configs.add(config);
        }
        return configs;
    }

    public static ThumbnailConfig parseConfig(String str) {
        ThumbnailConfigImpl config = null;
        str = str.trim();
        String[] fragments = (str = StringUtils.replaceEach((String)str, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""})).split(":");
        if (fragments.length >= 2) {
            try {
                Integer width = Integer.valueOf(fragments[0]);
                Integer height = Integer.valueOf(fragments[1]);
                boolean doCenter = false;
                if (fragments.length > 2) {
                    doCenter = Boolean.valueOf(fragments[2]);
                }
                config = new ThumbnailConfigImpl(width, height, doCenter);
            }
            catch (NumberFormatException e) {
                log.warn("parseConfig: cannot parse, invalid width/height specified in config [{}]: ", (Object)str, (Object)e);
            }
        } else {
            log.warn("parseConfig: cannot parse, insufficient arguments in config [{}].", (Object)str);
        }
        return config;
    }

    public static Collection<ThumbnailConfig> getConfigs(Collection<Integer[]> dimensions) {
        HashSet<ThumbnailConfig> configs = new HashSet<ThumbnailConfig>();
        for (Integer[] dimension : dimensions) {
            configs.add(new ThumbnailConfigImpl(dimension[0], dimension[1], false));
        }
        return configs;
    }

    private Layer createThumbnail(Layer layer, ThumbnailConfig config) {
        Layer finalLayer = null;
        int maxWidth = config.getWidth();
        int maxHeight = config.getHeight();
        boolean doCenter = config.doCenter();
        int width = layer.getWidth();
        int height = layer.getHeight();
        Color bgColor = layer.getBackgroundColor();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = width * maxHeight / height;
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = height * maxWidth / width;
                }
            } else {
                newWidth = maxWidth;
                newHeight = height * maxWidth / width;
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = width * maxHeight / height;
                }
            }
            layer.resize(newWidth, newHeight, true);
        }
        if ((layer.getHeight() < maxHeight || layer.getWidth() < maxWidth) && doCenter) {
            Color bg = null != bgColor ? bgColor : Color.WHITE;
            finalLayer = new Layer(maxWidth, maxHeight, (Paint)bg);
            finalLayer.setTransparency(bg);
            int y = (maxHeight - layer.getHeight()) / 2;
            int x = (maxWidth - layer.getWidth()) / 2;
            layer.setX(x);
            layer.setY(y);
            finalLayer.merge(layer);
        }
        if (finalLayer == null) {
            return layer;
        }
        return finalLayer;
    }
}

