/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUtil {
    private static final String TIFF_BITS_PER_SAMPLE = "tiff:BitsPerSample";
    private static final String DAM_BITSPERPIXEL = "dam:Bitsperpixel";
    private static final String PHOTOSHOP_COLOR_MODE = "photoshop:ColorMode";
    private static final String TIFF_SAMPLES_PER_PIXEL = "tiff:SamplesPerPixel";
    private static final Logger log = LoggerFactory.getLogger(MemoryUtil.class);
    public static long MIN_CQ_MEMORY_REQUIREMENT = 0x6400000L;

    public static boolean hasEnoughSystemMemory(Asset asset) {
        if (MemoryUtil.canCalculate(asset)) {
            long expectedImageMem = MemoryUtil.getExpectedImageMemory(asset);
            return Runtime.getRuntime().maxMemory() > MIN_CQ_MEMORY_REQUIREMENT + expectedImageMem;
        }
        log.debug("Cannot calculate memory requirements for " + asset.getPath());
        return true;
    }

    public static long getExpectedImageMemory(Asset asset) {
        if (MemoryUtil.canCalculate(asset)) {
            long length = 0L;
            long width = 0L;
            Map metadata = asset.getMetadata();
            if (metadata.containsKey("exif:PixelXDimension") && metadata.containsKey("exif:PixelYDimension")) {
                length = MemoryUtil.getAsLong(asset, metadata, "exif:PixelXDimension");
                width = MemoryUtil.getAsLong(asset, metadata, "exif:PixelYDimension");
            } else {
                length = MemoryUtil.getAsLong(asset, metadata, "tiff:ImageLength");
                width = MemoryUtil.getAsLong(asset, metadata, "tiff:ImageWidth");
            }
            return (long)MemoryUtil.getPixelSize(asset, metadata) * width * length;
        }
        return -1L;
    }

    private static int getPixelSize(Asset asset, Map<String, Object> metadata) {
        int pixelSize = 4;
        int oneByte = 8;
        if (metadata.containsKey(DAM_BITSPERPIXEL)) {
            pixelSize = (int)MemoryUtil.getAsLong(asset, metadata, DAM_BITSPERPIXEL);
            return pixelSize /= oneByte;
        }
        int bitsPerChannel = (int)MemoryUtil.getBitsPerSample(asset, metadata);
        int bytesPerChannel = bitsPerChannel / oneByte;
        if (metadata.containsKey(PHOTOSHOP_COLOR_MODE)) {
            int colorMode = (int)MemoryUtil.getAsLong(asset, metadata, PHOTOSHOP_COLOR_MODE);
            switch (colorMode) {
                case 0: 
                case 1: 
                case 2: {
                    pixelSize = 1;
                    break;
                }
                case 3: {
                    pixelSize = 3;
                    break;
                }
                default: {
                    pixelSize = 4;
                }
            }
            return pixelSize * bytesPerChannel;
        }
        if (metadata.containsKey(TIFF_SAMPLES_PER_PIXEL)) {
            pixelSize = (int)MemoryUtil.getAsLong(asset, metadata, TIFF_SAMPLES_PER_PIXEL);
            return pixelSize * bytesPerChannel;
        }
        return pixelSize;
    }

    private static long getBitsPerSample(Asset asset, Map<String, Object> metadata) {
        Object[] values;
        Object value = metadata.get(TIFF_BITS_PER_SAMPLE);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Object[] && (values = (Object[])value).length > 0) {
            return MemoryUtil.getAsLong(asset, values[0]);
        }
        return 8L;
    }

    private static long getAsLong(Asset asset, Map<String, Object> metadata, String name) {
        Object value = metadata.get(name);
        return MemoryUtil.getAsLong(asset, value);
    }

    private static long getAsLong(Asset asset, Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            try {
                return Long.valueOf(strVal);
            }
            catch (NumberFormatException nme) {
                log.debug("Cannot convert {} to number for asset {}", value, (Object)asset.getPath());
            }
        }
        return 0L;
    }

    public static boolean hasEnoughMemory(Asset asset) {
        if (MemoryUtil.canCalculate(asset)) {
            long expectedImageMem = MemoryUtil.getExpectedImageMemory(asset);
            Runtime rt = Runtime.getRuntime();
            long maxFreeMem = rt.maxMemory() - (rt.totalMemory() - rt.freeMemory());
            return maxFreeMem >= expectedImageMem;
        }
        log.debug("Cannot calculate memory requirements for " + asset.getPath());
        return true;
    }

    public static long suggestMaxHeapSize(Asset asset) {
        return MemoryUtil.getExpectedImageMemory(asset) + MIN_CQ_MEMORY_REQUIREMENT;
    }

    private static boolean canCalculate(Asset asset) {
        return asset.getMetadata("tiff:ImageLength") != null && asset.getMetadata("tiff:ImageWidth") != null || asset.getMetadata("exif:PixelXDimension") != null && asset.getMetadata("exif:PixelYDimension") != null;
    }
}

