/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.image.Layer;

public class OrientationUtil {
    public static final short ORIENTATION_NORMAL = 1;
    public static final short ORIENTATION_MIRROR_HORIZONTAL = 2;
    public static final short ORIENTATION_ROTATE_180 = 3;
    public static final short ORIENTATION_MIRROR_VERTICAL = 4;
    public static final short ORIENTATION_MIRROR_HORIZONTAL_ROTATE_270_CW = 5;
    public static final short ORIENTATION_ROTATE_90_CW = 6;
    public static final short ORIENTATION_MIRROR_HORIZONTAL_ROTATE_90_CW = 7;
    public static final short ORIENTATION_ROTATE_270_CW = 8;
    static final String EXIF_ORIENTATION = "exif:Orientation";
    static final String TIFF_ORIENTATION = "tiff:Orientation";

    public static boolean hasOrientationMetadata(Asset asset) {
        return asset.getMetadata(EXIF_ORIENTATION) != null || asset.getMetadata(TIFF_ORIENTATION) != null;
    }

    public static void adjustOrientation(Asset asset, Layer layer) {
        Object value = asset.getMetadata(EXIF_ORIENTATION);
        if (value == null) {
            value = asset.getMetadata(TIFF_ORIENTATION);
        }
        if (value == null) {
            return;
        }
        Short orientation = 1;
        if (value instanceof Long) {
            orientation = ((Long)value).shortValue();
        } else if (value instanceof String) {
            orientation = Short.parseShort((String)value);
        }
        switch (orientation) {
            case 2: {
                layer.flipHorizontally();
                break;
            }
            case 3: {
                layer.rotate(180.0);
                break;
            }
            case 4: {
                layer.flipVertically();
                break;
            }
            case 5: {
                layer.flipHorizontally();
                layer.rotate(270.0);
                break;
            }
            case 6: {
                layer.rotate(90.0);
                break;
            }
            case 7: {
                layer.flipHorizontally();
                layer.rotate(90.0);
                break;
            }
            case 8: {
                layer.rotate(270.0);
            }
        }
    }
}

