/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import java.util.Iterator;

public class PrefixRenditionPicker
implements RenditionPicker {
    private String prefix;
    private boolean returnOriginal;

    public PrefixRenditionPicker(String startsWith) {
        this(startsWith, false);
    }

    public PrefixRenditionPicker(String prefix, boolean returnOriginal) {
        this.prefix = prefix;
        this.returnOriginal = returnOriginal;
    }

    public Rendition getRendition(Asset asset) {
        Iterator renditions = asset.listRenditions();
        while (renditions.hasNext()) {
            Rendition rendition = (Rendition)renditions.next();
            if (!rendition.getName().startsWith(this.prefix)) continue;
            return rendition;
        }
        if (this.returnOriginal) {
            return asset.getOriginal();
        }
        return null;
    }
}

