/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.s7dam.set.ImageSet;
import com.day.cq.dam.api.s7dam.set.SwatchSet;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S7SetHelper {
    private static String MIME_TYPE = "Multipart/Related; type=application/x-";

    public static ImageSet createS7ImageSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "ImageSet");
        return (ImageSet)resource.adaptTo(SwatchSet.class);
    }

    private static Resource createS7Set(Resource parent, String name, Map<String, Object> props, String type) throws PersistenceException {
        if (parent != null && name != null) {
            ResourceResolver resolver = parent.getResourceResolver();
            String path = parent.getPath() + "/" + name;
            AssetManager am = (AssetManager)resolver.adaptTo(AssetManager.class);
            Asset asset = am.createAsset(path);
            ValueMap vm = (ValueMap)asset.adaptTo(ValueMap.class);
            vm.put((Object)"dam:s7damType", (Object)type);
            if (props != null) {
                vm.putAll(props);
            }
            Resource metadataResource = resolver.getResource((Resource)asset, "jcr:content/metadata");
            ModifiableValueMap metadataVm = (ModifiableValueMap)metadataResource.adaptTo(ModifiableValueMap.class);
            metadataVm.put((Object)"dc:format", (Object)(MIME_TYPE + type));
            resolver.commit();
            return resolver.getResource(path);
        }
        throw new IllegalArgumentException("parent resource or name can not be null");
    }

    public static SwatchSet createS7SwatchSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "SwatchSet");
        return (SwatchSet)resource.adaptTo(SwatchSet.class);
    }

    public static boolean isS7Set(Resource resource) {
        ValueMap vm;
        String s7Type;
        Resource contentResource = resource.getChild("jcr:content");
        return contentResource != null && ("ImageSet".equals(s7Type = (String)(vm = (ValueMap)contentResource.adaptTo(ValueMap.class)).get("dam:s7damType", (Object)"")) || "SwatchSet".equals(s7Type));
    }
}

