/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.AssetReferenceSearch;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={ReferenceProvider.class})
public class AssetReferenceProvider
implements ReferenceProvider {
    private static final String TYPE_ASSET = "asset";

    public List<Reference> findReferences(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return Collections.emptyList();
        }
        AssetReferenceSearch referenceSearch = new AssetReferenceSearch(node, "/content/dam", resource.getResourceResolver());
        Map<String, Asset> assets = referenceSearch.search();
        ArrayList<Reference> references = new ArrayList<Reference>(assets.size());
        for (Map.Entry<String, Asset> assetEntry : assets.entrySet()) {
            Asset asset = assetEntry.getValue();
            Resource assetResource = (Resource)asset.adaptTo(Resource.class);
            long lastModified = asset.getLastModified();
            if (lastModified == 0L) {
                lastModified = -1L;
            }
            references.add(new Reference(TYPE_ASSET, asset.getName(), assetResource, lastModified));
        }
        return references;
    }
}

