/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.day.cq.dam.commons.handler.AbstractFilter;
import java.io.IOException;

public class XPacketFilter
extends AbstractFilter {
    private static final byte[] XPACKET_BEGIN = "<?xpacket begin=".getBytes();
    private static final byte[] XPACKET_END = "<?xpacket end=".getBytes();
    private static final byte[] XPACKET_TERMINATOR = "?>".getBytes();
    private ParseState ps = ParseState.XPACKET_BEGIN;
    private int markerPos;

    protected void doFilter(byte[] buf, int off, int len) throws IOException {
        int startIndex = this.ps != ParseState.XPACKET_BEGIN ? 0 : -1;
        block6: for (int i = 0; i < len; ++i) {
            byte b = buf[off + i];
            switch (this.ps) {
                case XPACKET_BEGIN: {
                    if (b == XPACKET_BEGIN[this.markerPos]) {
                        ++this.markerPos;
                        if (this.markerPos != XPACKET_BEGIN.length) continue block6;
                        this.notifyStarted();
                        this.put(XPACKET_BEGIN);
                        this.ps = ParseState.XPACKET_BEGIN_TERM;
                        this.markerPos = 0;
                        startIndex = i + 1;
                        continue block6;
                    }
                    this.markerPos = 0;
                    if (b != XPACKET_BEGIN[this.markerPos]) continue block6;
                    ++this.markerPos;
                    continue block6;
                }
                case XPACKET_BEGIN_TERM: {
                    if (b == XPACKET_TERMINATOR[this.markerPos]) {
                        ++this.markerPos;
                        if (this.markerPos != XPACKET_TERMINATOR.length) continue block6;
                        this.put(buf, off + startIndex, i - startIndex + 1);
                        this.ps = ParseState.XPACKET_END;
                        this.markerPos = 0;
                        startIndex = i + 1;
                        continue block6;
                    }
                    this.markerPos = 0;
                    if (b != XPACKET_TERMINATOR[this.markerPos]) continue block6;
                    ++this.markerPos;
                    continue block6;
                }
                case XPACKET_END: {
                    if (b == XPACKET_END[this.markerPos]) {
                        ++this.markerPos;
                        if (this.markerPos != XPACKET_END.length) continue block6;
                        this.put(buf, off + startIndex, i - startIndex + 1);
                        this.ps = ParseState.XPACKET_END_TERM;
                        this.markerPos = 0;
                        startIndex = i + 1;
                        continue block6;
                    }
                    this.markerPos = 0;
                    if (b != XPACKET_END[this.markerPos]) continue block6;
                    ++this.markerPos;
                    continue block6;
                }
                case XPACKET_END_TERM: {
                    if (b == XPACKET_TERMINATOR[this.markerPos]) {
                        ++this.markerPos;
                        if (this.markerPos != XPACKET_TERMINATOR.length) continue block6;
                        this.put(buf, off + startIndex, i - startIndex + 1);
                        this.ps = ParseState.END;
                        startIndex = -1;
                        this.notifyEnded();
                        continue block6;
                    }
                    this.markerPos = 0;
                    if (b != XPACKET_TERMINATOR[this.markerPos]) continue block6;
                    ++this.markerPos;
                }
            }
        }
        if (startIndex >= 0) {
            this.put(buf, off + startIndex, len - startIndex);
        }
    }

    protected void doReset() {
        super.doReset();
        this.ps = ParseState.XPACKET_BEGIN;
        this.markerPos = 0;
    }

    public boolean isValid() {
        return this.ps == ParseState.END;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseState {
        XPACKET_BEGIN,
        XPACKET_BEGIN_TERM,
        XPACKET_END,
        XPACKET_END_TERM,
        END;

    }
}

