/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.cq.commerce.api.Product;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.dam.commons.util.UIHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamUtil {
    private static final Logger log = LoggerFactory.getLogger(DamUtil.class);
    private static final String[] IMG_MIME_TYPES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/png", "image/bmp", "image/gif", "image/pipeg", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-icon", "image/photoshop", "image/x-photoshop", "image/psd", "application/photoshop", "application/psd", "image/vnd.adobe.photoshop"};
    private static final String[] VID_MIME_TYPES = new String[]{"video/m4v", "video/flv", "video/avi", "video/mov", "video/3gpp", "application/x-troff-msvideo", "video/vnd", "model/vnd.mts", "video/ts", "video/vnd", "video/dvd", "video/x-ms-wmv", "video/msvideo", "video/x-msvideo", "video/x-flv", "video/mpeg", "video/x-mpeg", "video/x-m4v", "video/mpg", "video/x-mpg", "video/mpeg2", "video/x-mpeg2a", "video/mts", "video/x-ms-asf", "video/3gpp2", "video/x-f4v", "video/f4v", "video/m2p", "video/mp2t", "video/avchd-stream", "video/m2ts", "video/mp2t", "video/vnd.dlna.mpeg-tts", "video/m2v", "video/quicktime", "video/x-quicktime", "video/mp4", "video/ogg", "video/x-mxf", "application/mxf", "video/x-matroska", "video/mj2", "video/vnd.rn-realvideo", "application/vnd.rn-realmedia", "video/webm"};
    private static final List<String> IMG_MIME_TYPE = Arrays.asList(IMG_MIME_TYPES);
    private static final List<String> VID_MIME_TYPE = Arrays.asList(VID_MIME_TYPES);
    private static final String APPLIED_PROCESSING_PROFILE_PROPERTY = "jcr:content/processingProfile";
    private static final int MAGIC_SIZE = 1024;

    public static String assetToBinaryPath(String path) {
        String binaryPath = null;
        if (StringUtils.startsWith((String)path, (String)"/content/dam")) {
            binaryPath = StringUtils.replaceOnce((String)path, (String)"/content/dam", (String)"/var/dam");
        }
        return binaryPath;
    }

    public static String binaryToAssetPath(String path) {
        String assetPath = null;
        if (StringUtils.startsWith((String)path, (String)"/var/dam")) {
            assetPath = StringUtils.replaceOnce((String)path, (String)"/var/dam", (String)"/content/dam");
        }
        return assetPath;
    }

    public static boolean isThumbnail(Node file) {
        try {
            return file.isNodeType("nt:file") && file.getName().startsWith("cq5dam.thumbnail");
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public static String getThumbnailName(int width, int height) {
        return DamUtil.getThumbnailName(width, height, null);
    }

    public static String getThumbnailName(ThumbnailConfig config) {
        String[] stringArray;
        if (config.doCenter()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "margin";
        } else {
            stringArray = null;
        }
        String[] selectors = stringArray;
        return DamUtil.getThumbnailName(config.getWidth(), config.getHeight(), selectors);
    }

    public static String getThumbnailName(int width, int height, String[] selectors) {
        String selectorString = StringUtils.join((Object[])(selectors = null != selectors ? selectors : new String[]{}), (char)'.');
        if (!"".equals(selectorString)) {
            selectorString = "." + selectorString;
        }
        return "cq5dam.thumbnail." + String.valueOf(width) + "." + String.valueOf(height) + selectorString + ".png";
    }

    public static boolean isRendition(Resource resource) {
        if (null == resource) {
            return false;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        if (null == parent) {
            return false;
        }
        Resource content = ResourceUtil.getParent((Resource)parent);
        if (null == content) {
            return false;
        }
        Resource asset = ResourceUtil.getParent((Resource)content);
        if (null == asset) {
            return false;
        }
        return "renditions".equals(ResourceUtil.getName((Resource)parent)) && (DamUtil.isAsset(asset) || DamUtil.isFrozenNode(asset));
    }

    public static boolean isAsset(Resource resource) {
        return null != resource && "dam:Asset".equals(resource.getResourceType());
    }

    public static boolean isFrozenNode(Resource resource) {
        return null != resource && "nt:frozenNode".equals(resource.getResourceType());
    }

    public static boolean isSubAsset(Resource resource) {
        return DamUtil.isAsset(resource) && "subassets".equals(ResourceUtil.getName((Resource)ResourceUtil.getParent((Resource)resource)));
    }

    public static Asset resolveToAsset(Resource resource) {
        if (null != resource && DamUtil.isAsset(resource)) {
            return (Asset)resource.adaptTo(Asset.class);
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        if (null != parent) {
            return DamUtil.resolveToAsset(parent);
        }
        return null;
    }

    public static void setModified(Asset asset, String user, Calendar date) {
        try {
            Node contentNode = ((Node)asset.adaptTo(Node.class)).getNode("jcr:content");
            contentNode.setProperty("jcr:lastModifiedBy", user);
            contentNode.setProperty("jcr:lastModified", date);
            contentNode.getSession().save();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public static List<String> findExpiringAssets(Session session, Calendar lowerBound, Calendar upperBound) throws RepositoryException {
        ArrayList<String> results = null;
        QueryObjectModel qom = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryObjectModelFactory qomf = queryManager.getQOMFactory();
            Selector damAsset = qomf.selector("dam:Asset", "selector_0");
            Selector assetContent = qomf.selector("dam:AssetContent", "selector_1");
            ValueFactory vf = session.getValueFactory();
            PropertyValue expiryDateOprnd = qomf.propertyValue("selector_1", "offTime");
            Object expiryDateConstrnt = null;
            Comparison upperBndConstrnt = null;
            if (upperBound != null) {
                Literal upperBndOprnd = qomf.literal(vf.createValue(upperBound));
                expiryDateConstrnt = upperBndConstrnt = qomf.comparison((DynamicOperand)expiryDateOprnd, "jcr.operator.less.than", (StaticOperand)upperBndOprnd);
            }
            if (lowerBound != null) {
                Literal lowerBndOprnd = qomf.literal(vf.createValue(lowerBound));
                Comparison lowerBndConstrnt = qomf.comparison((DynamicOperand)expiryDateOprnd, "jcr.operator.greater.than.or.equal.to", (StaticOperand)lowerBndOprnd);
                expiryDateConstrnt = upperBndConstrnt != null ? qomf.and((Constraint)upperBndConstrnt, (Constraint)lowerBndConstrnt) : lowerBndConstrnt;
            }
            SameNodeJoinCondition joinAssetToJcrContent = qomf.sameNodeJoinCondition("selector_1", "selector_0", "jcr:content");
            assetContent = qomf.join((Source)damAsset, (Source)assetContent, "jcr.join.type.inner", (JoinCondition)joinAssetToJcrContent);
            qom = qomf.createQuery((Source)assetContent, (Constraint)expiryDateConstrnt, null, null);
            if (log.isDebugEnabled()) {
                log.debug("Expiring assets query [{}].", (Object)qom.getStatement());
            }
            long startTime = 0L;
            if (log.isTraceEnabled()) {
                startTime = System.currentTimeMillis();
            }
            QueryResult result = qom.execute();
            if (log.isTraceEnabled()) {
                long endTime = System.currentTimeMillis();
                log.trace("Time taken to execute query [{}] ms", (Object)new Long(endTime - startTime));
            }
            RowIterator rowIter = result.getRows();
            long resultSize = rowIter.getSize();
            results = new ArrayList<String>(new Long(resultSize).intValue());
            if (log.isDebugEnabled()) {
                log.debug("ResultSet size [{}].", (Object)resultSize);
            }
            if (log.isTraceEnabled()) {
                log.trace("Logging search result set");
            }
            while (rowIter.hasNext()) {
                Row row = rowIter.nextRow();
                Node node = row.getNode("selector_0");
                String path = node.getPath();
                if (log.isTraceEnabled()) {
                    log.trace("path  [{}]", (Object)path);
                }
                results.add(path);
            }
        }
        catch (RepositoryException e) {
            if (qom != null) {
                log.error("Expired assets query [{}].", (Object)qom.getStatement());
            }
            log.error("Error in finding expired assets", (Throwable)e);
            throw e;
        }
        return results;
    }

    public static String getValue(Node n, String name, String defaultValue) throws RepositoryException {
        if (n == null) {
            return defaultValue;
        }
        try {
            Property p = n.getProperty(name);
            if (!p.isMultiple()) {
                return p.getString();
            }
            Value[] values = p.getValues();
            String val = "";
            boolean first = true;
            for (Value a : values) {
                if (!first) {
                    val = val + ", ";
                } else {
                    first = false;
                }
                val = val + a.getString();
            }
            return val;
        }
        catch (PathNotFoundException pathNotFoundException) {
            return defaultValue;
        }
    }

    public static boolean isImage(Asset asset) {
        return IMG_MIME_TYPE.contains(asset.getMimeType());
    }

    public static boolean isVideo(Asset asset) {
        String[] errantTypes = new String[]{"mpv", "m2ts", "m2t", "m2p", "vob", "ts", "webm", "mkv"};
        List<String> errantList = Arrays.asList(errantTypes);
        return VID_MIME_TYPE.contains(asset.getMimeType()) || asset.getMimeType() == null && errantList.contains(StringUtils.substringAfterLast((String)asset.getName(), (String)".").toLowerCase());
    }

    public static boolean isSmartCollection(Resource resource) {
        return resource.isResourceType("dam/smartcollection");
    }

    public static Node getApplicableProfile(Asset asset, String profileType, Session session) {
        try {
            Node node;
            String path = DamUtil.getAppliedProcessingProfilePath(asset);
            if (path != null && session.nodeExists(path + "/" + "jcr:content") && (node = session.getNode(path + "/" + "jcr:content")) != null && node.hasProperty(profileType) && session.nodeExists(path = node.getProperty(profileType).getString())) {
                return session.getNode(path);
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to retrieve applicable profile", (Throwable)e);
        }
        return null;
    }

    public static String getAppliedProcessingProfilePath(Asset asset) {
        Node assetNode = (Node)asset.adaptTo(Node.class);
        try {
            if (null != assetNode) {
                Node parentNode = assetNode.getParent();
                while (!parentNode.getPath().equals("/content")) {
                    if (!parentNode.getPrimaryNodeType().getName().equals("dam:Asset") && parentNode.hasProperty(APPLIED_PROCESSING_PROFILE_PROPERTY)) {
                        return parentNode.getProperty(APPLIED_PROCESSING_PROFILE_PROPERTY).getString();
                    }
                    parentNode = parentNode.getParent();
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to locate processing profile path", (Throwable)e);
        }
        return null;
    }

    public static Iterator<Asset> getAssets(Resource res) {
        Asset asset = (Asset)res.adaptTo(Asset.class);
        if (asset == null) {
            return new FolderAssetIterator(res);
        }
        return Collections.singletonList(asset).iterator();
    }

    public static Iterator<Asset> getPreviewAssets(Resource res) {
        Asset asset = (Asset)res.adaptTo(Asset.class);
        if (asset == null) {
            return new FolderAssetIterator(res, true);
        }
        return Collections.singletonList(asset).iterator();
    }

    public static boolean checkforAIFile(Asset asset) {
        if (asset != null && asset.getOriginal() != null) {
            InputStream in = asset.getOriginal().getStream();
            PushbackInputStream pin = new PushbackInputStream(in, 1024);
            byte[] data = new byte[1024];
            try {
                int len = pin.read(data);
                if (len <= 0) {
                    return false;
                }
                pin.unread(data, 0, len);
                byte[] pdfMarker = new byte[]{37, 80, 68, 70, 45};
                int size = 1024;
                if (size > len) {
                    size = len;
                }
                byte[] header = new byte[size];
                System.arraycopy(data, 0, header, 0, size);
                long result = Utility.KMPFindFirst((byte[])pdfMarker, (int[])Utility.ComputeKMPNextArray((byte[])pdfMarker), (byte[])header);
                return result >= 0L;
            }
            catch (IOException e) {
                log.warn("I/O error while getting metadata.", (Throwable)e);
            }
        }
        return false;
    }

    public static Rendition getBestFitRendition(int width, List<Rendition> renditions) {
        Rendition rend;
        PrefixRenditionPicker prefixPicker = new PrefixRenditionPicker("cq5dam.thumbnail." + width);
        Rendition bestFitRendition = prefixPicker.getRendition(renditions.iterator());
        if (bestFitRendition != null) {
            return bestFitRendition;
        }
        WidthBasedRenditionComparator comp = new WidthBasedRenditionComparator();
        Collections.sort(renditions, comp);
        Iterator<Rendition> itr = renditions.iterator();
        Rendition bestFit = null;
        while (itr.hasNext()) {
            int w;
            rend = itr.next();
            if (!UIHelper.canRenderOnWeb(rend.getMimeType()) || (w = UIHelper.getWidth(rend)) > width) continue;
            bestFit = rend;
        }
        itr = renditions.iterator();
        if (bestFit == null) {
            while (itr.hasNext()) {
                rend = itr.next();
                if (!UIHelper.canRenderOnWeb(rend.getMimeType())) continue;
                bestFit = rend;
                break;
            }
        }
        return bestFit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderAssetIterator
    implements Iterator<Asset> {
        private Resource parentResource;
        private Iterator<Resource> it = null;
        private Stack<Iterator<Resource>> suspended = new Stack();
        private List<Resource> parentNodes = new ArrayList<Resource>();
        private Asset next = null;
        private boolean forPreview = false;

        private Iterator<Resource> getChildren(Resource res) {
            ResourceCollection rc = (ResourceCollection)res.adaptTo(ResourceCollection.class);
            if (rc != null) {
                return rc.getResources();
            }
            return res.listChildren();
        }

        public FolderAssetIterator(Resource resource) {
            this.parentResource = resource;
            this.it = this.getChildren(this.parentResource);
            this.next = this.getNext();
        }

        public FolderAssetIterator(Resource resource, boolean forPreview) {
            this.parentResource = resource;
            this.forPreview = forPreview;
            this.it = this.getChildren(this.parentResource);
            this.next = this.getNext();
        }

        private Asset getNext() {
            while (!this.it.hasNext() && !this.parentNodes.isEmpty()) {
                this.it = this.getChildren(this.parentNodes.remove(0));
            }
            while (!this.it.hasNext() && !this.suspended.isEmpty()) {
                this.it = this.suspended.pop();
            }
            while (this.it.hasNext()) {
                Resource member = this.it.next();
                Node n = (Node)member.adaptTo(Node.class);
                Asset a = null;
                try {
                    Product p;
                    if (n.isNodeType("dam:Asset")) {
                        a = (Asset)member.adaptTo(Asset.class);
                    } else if (n.isNodeType("nt:folder") || member.adaptTo(ResourceCollection.class) != null) {
                        this.parentNodes.add(member);
                    } else if (this.forPreview && (p = (Product)member.adaptTo(Product.class)) != null) {
                        String imageReference = p.getImage().getFileReference();
                        Resource image = member.getResourceResolver().getResource(imageReference);
                        if (image != null) {
                            a = (Asset)image.adaptTo(Asset.class);
                        }
                    }
                    if (a == null) continue;
                    if (this.forPreview && !this.parentNodes.isEmpty()) {
                        this.suspended.push(this.it);
                        this.it = this.getChildren(this.parentNodes.remove(0));
                    }
                    return a;
                }
                catch (RepositoryException e) {
                    log.error("unexpected exception ", (Throwable)e);
                }
            }
            if (!this.parentNodes.isEmpty()) {
                return this.getNext();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Asset next() {
            Asset toReturn = this.next;
            this.next = this.getNext();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowed for asset iterator on folder listing");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WidthBasedRenditionComparator
    implements Comparator<Rendition> {
        private WidthBasedRenditionComparator() {
        }

        @Override
        public int compare(Rendition r1, Rendition r2) {
            int w2;
            int w1 = UIHelper.getWidth(r1);
            if (w1 < (w2 = UIHelper.getWidth(r2))) {
                return -1;
            }
            if (w1 == w2) {
                return 0;
            }
            return 1;
        }
    }
}

