/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.s7dam.config.DynamicMediaServicesConfig;
import java.util.Calendar;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMediaServicesConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMediaServicesConfigUtil.class);
    private static final int REGISTRATION_EXPIRES_SECONDS = 10800;
    private static byte[] key = new byte[]{111, 110, 39, 116, 32, 102, 111, 114, 103, 101, 116, 32, 116, 111, 100, 114};

    public static boolean isDynamicMediaServiceConfigured(ResourceResolver resolver) {
        return DynamicMediaServicesConfigUtil.getDefaultConfig(resolver) != null;
    }

    public static DynamicMediaServicesConfig getDefaultConfig(ResourceResolver resourceResolver) {
        Resource cloudResource = resourceResolver.getResource("/etc/cloudservices/dynamicmediaservices");
        Iterator dmConfigResourceIter = cloudResource.listChildren();
        while (dmConfigResourceIter.hasNext()) {
            DynamicMediaServicesConfig config = (DynamicMediaServicesConfig)((Resource)dmConfigResourceIter.next()).adaptTo(DynamicMediaServicesConfig.class);
            if (config == null || StringUtils.isEmpty((String)config.getRegistrationId())) continue;
            return config;
        }
        return null;
    }

    public static String getRegistrationId(ResourceResolver resourceResolver) {
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver);
        Calendar cal = Calendar.getInstance();
        long registrationTimeout = cal.getTimeInMillis() + 10800000L;
        try {
            if (config != null) {
                return DynamicMediaServicesConfigUtil.encrypt(config.getRegistrationId() + "|" + String.valueOf(registrationTimeout));
            }
        }
        catch (Exception e) {
            LOG.error("Failed while creating encrypted key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            String enc = Base64.encodeBase64String((byte[])cipher.doFinal(strToEncrypt.getBytes()));
            return enc.replaceAll("/", "_slash_").replaceAll("\\?", "_qmark_");
        }
        catch (Exception e) {
            LOG.error("Error while encrypting", (Throwable)e);
            return null;
        }
    }

    public static String getPublicKey(ResourceResolver resourceResolver) {
        try {
            DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver);
            String regId = config.getRegistrationId();
            if (StringUtils.isNotBlank((String)regId) && regId.contains("|")) {
                return StringUtils.substringAfter((String)regId, (String)"|");
            }
        }
        catch (Exception e) {
            LOG.error("Failed while extracting public key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    public static String getServiceUrl(ResourceResolver resourceResolver) {
        String videoServiceUrl = null;
        try {
            String path = "/etc/cloudservices/dynamicmediaservices/jcr:content";
            Resource res = resourceResolver.getResource(path);
            Node node = (Node)res.adaptTo(Node.class);
            if (node.hasProperty("serviceUrl")) {
                videoServiceUrl = node.getProperty("serviceUrl").getString();
            }
        }
        catch (PathNotFoundException e) {
            LOG.error("videoServiceUrl access error {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error("videoServiceUrl access error {}", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("videoServiceUrl access error {}", (Throwable)e);
        }
        return videoServiceUrl;
    }
}

