/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.image.Layer;
import org.apache.commons.lang.StringUtils;

public class OrientationUtil {
    public static final short ORIENTATION_NORMAL = 1;
    public static final short ORIENTATION_MIRROR_HORIZONTAL = 2;
    public static final short ORIENTATION_ROTATE_180 = 3;
    public static final short ORIENTATION_MIRROR_VERTICAL = 4;
    public static final short ORIENTATION_MIRROR_HORIZONTAL_ROTATE_270_CW = 5;
    public static final short ORIENTATION_ROTATE_90_CW = 6;
    public static final short ORIENTATION_MIRROR_HORIZONTAL_ROTATE_90_CW = 7;
    public static final short ORIENTATION_ROTATE_270_CW = 8;
    static final String EXIF_ORIENTATION = "exif:Orientation";
    static final String TIFF_ORIENTATION = "tiff:Orientation";

    public static boolean hasOrientationMetadata(Asset asset) {
        return StringUtils.isNotEmpty((String)asset.getMetadataValue(EXIF_ORIENTATION)) || StringUtils.isNotEmpty((String)asset.getMetadataValue(TIFF_ORIENTATION));
    }

    public static short getOrientation(Asset asset) {
        String value = asset.getMetadataValue(TIFF_ORIENTATION);
        if (StringUtils.isEmpty((String)value)) {
            value = asset.getMetadataValue(EXIF_ORIENTATION);
        }
        if (StringUtils.isEmpty((String)value)) {
            return 1;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException ne) {
            return 1;
        }
    }

    public static void adjustOrientation(Asset asset, Layer layer) {
        switch (OrientationUtil.getOrientation(asset)) {
            case 2: {
                layer.flipHorizontally();
                break;
            }
            case 3: {
                layer.rotate(180.0);
                break;
            }
            case 4: {
                layer.flipVertically();
                break;
            }
            case 5: {
                layer.flipHorizontally();
                layer.rotate(270.0);
                break;
            }
            case 6: {
                layer.rotate(90.0);
                break;
            }
            case 7: {
                layer.flipHorizontally();
                layer.rotate(90.0);
                break;
            }
            case 8: {
                layer.rotate(270.0);
            }
        }
    }
}

