/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.commons.schemaforms.internal.TabList;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaFormHelper {
    public static List<Resource> getMasterForms(Resource currentForm, String formsBaseDirPath) throws RepositoryException {
        ResourceResolver resolver = currentForm.getResourceResolver();
        String currentResourcePath = currentForm.getPath();
        String appsDIr = SchemaFormHelper.getAppsDir(resolver);
        String APPS_BASE_DIR = appsDIr + "/" + formsBaseDirPath;
        String APPS_BASE_DIR_NON_TENANT = "/apps/" + formsBaseDirPath;
        String LIBS_BASE_DIR = "/libs/" + formsBaseDirPath;
        ArrayList<Resource> masterFormsList = new ArrayList<Resource>();
        String path = currentResourcePath;
        Resource res = currentForm;
        while (!(path.equals(APPS_BASE_DIR) || path.equals(LIBS_BASE_DIR) || path.equals(APPS_BASE_DIR_NON_TENANT))) {
            path = (res = res.getParent()).getPath();
            String relativePath = path.startsWith("/libs") ? path.substring("/libs".length()) : (path.startsWith(appsDIr) ? path.substring(appsDIr.length()) : path.substring("/apps".length()));
            Resource resToVerify = resolver.getResource(appsDIr + relativePath);
            if (resToVerify != null && resToVerify.getChild("items/tabs") != null) {
                masterFormsList.add(resToVerify);
                continue;
            }
            resToVerify = resolver.getResource("/apps" + relativePath);
            if (resToVerify != null && resToVerify.getChild("items/tabs") != null) {
                masterFormsList.add(resToVerify);
                continue;
            }
            resToVerify = resolver.getResource("/libs" + relativePath);
            if (resToVerify == null) continue;
            masterFormsList.add(resToVerify);
        }
        Collections.reverse(masterFormsList);
        return masterFormsList;
    }

    public static Resource mergeFormTabResource(Resource oneTabList, Resource otherTabList) {
        if (oneTabList == null) {
            return otherTabList;
        }
        if (otherTabList == null) {
            return oneTabList;
        }
        TabList aTab = new TabList(oneTabList);
        TabList oTab = new TabList(otherTabList);
        aTab.merge((Resource)oTab);
        return aTab;
    }

    public static Resource getSchemaResource(SlingHttpServletRequest request) {
        String suffix = request.getRequestPathInfo().getSuffix();
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource res = resourceResolver.getResource(SchemaFormHelper.getAppsDir(resourceResolver) + suffix);
        if (res == null) {
            res = resourceResolver.getResource("/libs" + suffix);
        }
        return res;
    }

    private static String getAppsDir(ResourceResolver resolver) {
        String appsDir = "/apps";
        Tenant tenant = (Tenant)resolver.adaptTo(Tenant.class);
        if (tenant != null) {
            appsDir = appsDir + "/" + tenant.getId();
        }
        return appsDir;
    }

    public static Iterator getSchemaFormsIterator(SlingHttpServletRequest request, int rows, int offset) {
        String resName;
        String appsDir = SchemaFormHelper.getAppsDir(request.getResourceResolver());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        String suffix = request.getRequestPathInfo().getSuffix();
        String appsResPath = appsDir + suffix;
        String libsResPath = "/libs" + suffix;
        Resource appRes = resolver.getResource(appsResPath);
        Resource libsRes = resolver.getResource(libsResPath);
        if (appRes != null) {
            Iterator appIter = appRes.listChildren();
            while (appIter.hasNext()) {
                Resource ar = (Resource)appIter.next();
                resName = Text.getName((String)ar.getPath());
                if (libsRes != null && libsRes.getChild(resName) != null || !ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                resourceList.add(ar);
            }
        }
        if (libsRes != null) {
            Iterator libsIter = libsRes.listChildren();
            while (libsIter.hasNext()) {
                Resource lr = (Resource)libsIter.next();
                resName = Text.getName((String)lr.getPath());
                if (appRes != null && appRes.getChild(resName) != null && appRes.getChild(resName).getChild("items/tabs") != null) {
                    Resource ar = resolver.getResource(appRes.getPath() + "/" + resName);
                    if (!ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                    resourceList.add(ar);
                    continue;
                }
                if ((lr.getChild("items/tabs") == null || !lr.isResourceType("nt:folder")) && !lr.isResourceType("sling:OrderedFolder") && !lr.isResourceType("sling:Folder")) continue;
                resourceList.add(lr);
            }
        }
        return resourceList.iterator();
    }
}

