/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.collection.SmartCollection;
import com.day.cq.dam.commons.util.AssetReferenceRecursiveSearch;
import com.day.cq.dam.commons.util.AssetReferenceSearch;
import com.day.cq.dam.commons.util.S7SetHelper;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={ReferenceProvider.class})
public class AssetReferenceProvider
implements ReferenceProvider {
    private static final String TYPE_ASSET = "asset";
    private static final String TYPE_S7SET = "s7set";
    private static final String TYPE_COLLECTION = "collection";
    private static final String TYPE_FOLDER = "folder";
    private static final Logger log = LoggerFactory.getLogger(AssetReferenceProvider.class);

    public List<Reference> findReferences(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        if (resource.getPath().endsWith("jcr:content")) {
            resource = resource.getParent();
        }
        if (S7SetHelper.isS7Set(resource) || resource.adaptTo(ResourceCollection.class) != null || resource.adaptTo(SmartCollection.class) != null) {
            AssetReferenceRecursiveSearch referenceSearch = new AssetReferenceRecursiveSearch(node, "/content/dam", resource.getResourceResolver());
            Map<String, Resource> resources = referenceSearch.search();
            for (Map.Entry<String, Resource> resourceEntry : resources.entrySet()) {
                Resource resourceRef = resourceEntry.getValue();
                String name = resourceRef.getName();
                Node refNode = (Node)resourceRef.adaptTo(Node.class);
                if (refNode != null) {
                    try {
                        if (refNode.hasProperty("jcr:title")) {
                            name = refNode.getProperty("jcr:title").getString();
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                long lastModifiedTimeStamp = this.getLastModifiedTimeStamp(resourceRef);
                try {
                    if (S7SetHelper.isS7Set(resourceRef)) {
                        references.add(new Reference(TYPE_S7SET, name, resourceRef, lastModifiedTimeStamp));
                        continue;
                    }
                    if (resourceRef.adaptTo(ResourceCollection.class) != null) {
                        references.add(new Reference(TYPE_COLLECTION, name, resourceRef, lastModifiedTimeStamp));
                        continue;
                    }
                    if (((Node)resourceRef.adaptTo(Node.class)).isNodeType("nt:folder")) {
                        references.add(new Reference(TYPE_FOLDER, name, resourceRef, lastModifiedTimeStamp));
                        continue;
                    }
                    references.add(new Reference(TYPE_ASSET, name, resourceRef, lastModifiedTimeStamp));
                }
                catch (Exception e) {
                    log.warn("Error adding reference", (Throwable)e);
                }
            }
        } else {
            AssetReferenceSearch referenceSearch = new AssetReferenceSearch(node, "/content/dam", resource.getResourceResolver());
            Map<String, Asset> assets = referenceSearch.search();
            for (Map.Entry<String, Asset> assetEntry : assets.entrySet()) {
                Asset asset = assetEntry.getValue();
                Resource assetResource = (Resource)asset.adaptTo(Resource.class);
                long lastModified = asset.getLastModified();
                if (lastModified == 0L) {
                    lastModified = -1L;
                }
                references.add(new Reference(TYPE_ASSET, asset.getName(), assetResource, lastModified));
            }
        }
        return this.unique(references);
    }

    private List<Reference> unique(List<Reference> references) {
        ArrayList<String> pathsTraversed = new ArrayList<String>();
        ArrayList<Reference> uniqueReferences = new ArrayList<Reference>();
        for (Reference reference : references) {
            String path = reference.getResource().getPath();
            if (pathsTraversed.contains(path)) continue;
            pathsTraversed.add(path);
            uniqueReferences.add(reference);
        }
        return uniqueReferences;
    }

    private long getLastModifiedTimeStamp(Resource resource) {
        long lastModified = -1L;
        try {
            Calendar lastModifiedDate = null;
            ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
            if (properties.containsKey((Object)"jcr:lastModified")) {
                lastModifiedDate = (Calendar)properties.get("jcr:lastModified", Calendar.class);
            } else {
                ValueMap contentProperties;
                Resource contentResource = resource.getChild("jcr:content");
                if (contentResource != null && (contentProperties = ResourceUtil.getValueMap((Resource)contentResource)).containsKey((Object)"jcr:lastModified")) {
                    lastModifiedDate = (Calendar)contentProperties.get("jcr:lastModified", Calendar.class);
                }
            }
            if (lastModifiedDate == null) {
                lastModifiedDate = (Calendar)properties.get("jcr:created", Calendar.class);
            }
            lastModified = lastModifiedDate.getTimeInMillis();
        }
        catch (Exception e) {
            log.warn("Error accessing last modified date for resource", (Throwable)e);
        }
        if (lastModified == 0L) {
            lastModified = -1L;
        }
        return lastModified;
    }
}

