/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.gibson.fontmanager.impl;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSetManager;
import com.day.cq.dam.handler.gibson.fontmanager.FontManagerException;
import com.day.cq.dam.handler.gibson.fontmanager.FontManagerService;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Component(immediate=true, metatype=true, label="%fontmgr.name", description="%fontmgr.description")
public class FontManagerServiceImpl
implements FontManagerService {
    private Logger log = LoggerFactory.getLogger(FontManagerServiceImpl.class);
    private static final String FONTS_SRC_SYSTEM = "System";
    private static final String FONTS_SRC_ADOBE = "Adobe Server";
    private static final String FONTS_SRC_CUSTOMER = "Customer";
    @Property(name="fontmgr.system.font.dir", value={""}, unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_SYSTEM_FONT_DIR = "fontmgr.system.font.dir";
    @Property(name="fontmgr.adobe.font.dir", value={""})
    private static final String PROP_ADOBE_FONT_DIR = "fontmgr.adobe.font.dir";
    @Property(name="fontmgr.customer.font.dir", value={""})
    private static final String PROP_CUSTOMER_FONT_DIR = "fontmgr.customer.font.dir";
    private static final String PATH_SEP = ";";
    private static final int FONT_DIRS_LIMIT = 50;
    private String systemFontDir;
    private String adobeFontDir;
    private String customerFontDir;
    private PDFFontSet pdfFontSet = null;
    private FontStats fontStats = new FontStats();

    @Override
    public PDFFontSet getPdfFontSet() {
        this.makePdfFontSet();
        try {
            return PDFFontSetManager.getPDFFontSetInstance((PDFFontSet)this.pdfFontSet);
        }
        catch (PDFFontException e) {
            throw new FontManagerException(1004, "Problem creating a copy of pdfFontSet", e);
        }
    }

    private void makePdfFontSet() {
        if (this.pdfFontSet == null) {
            StopWatch sw = new StopWatch();
            sw.start();
            this.fontStats = new FontStats();
            this.loadNewFonts();
            this.fontStats.process();
            sw.stop();
            this.log.info("Successfully loaded {} fonts in duration {}", (Object)this.fontStats.fontCount, (Object)DurationFormatUtils.formatDurationWords((long)sw.getTime(), (boolean)true, (boolean)true));
        }
    }

    private void loadNewFonts() {
        try {
            this.pdfFontSet = PDFFontSetManager.getPDFFontSetInstance((FontResolutionPriority)FontResolutionPriority.INTELLIGENT_FIRST);
            if (this.pdfFontSet == null) {
                throw new FontManagerException(1004, "FontManager: Cannot create PDFFontSet object : getPDFFontSetInstance() returns null");
            }
        }
        catch (PDFFontException e) {
            throw new FontManagerException(1004, "FontManager: Problem creating PDFFontSet object", e);
        }
        if (this.customerFontDir != null || this.adobeFontDir != null || this.systemFontDir != null) {
            this.loadFromFontDirectories(this.pdfFontSet);
        }
        this.loadDefaultFallbackFonts(this.pdfFontSet);
    }

    private void loadDefaultFallbackFonts(PDFFontSet pdfFontSet) {
        try {
            pdfFontSet.addFallbackFont(ULocale.ROOT.toLocale(), Base14.helveticaRegular);
        }
        catch (PDFFontException e) {
            this.log.error("loadDefaultFallbackFonts: Failed ");
        }
    }

    private void loadFromFontDirectories(PDFFontSet pdfFontSet) {
        boolean loaded = false;
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (this.customerFontDir != null) {
            loaded = this.loadFontsFromDirStr(this.customerFontDir, FONTS_SRC_CUSTOMER, pdfFontSet, exceptions);
        }
        if (this.adobeFontDir != null) {
            loaded |= this.loadFontsFromDirStr(this.adobeFontDir, FONTS_SRC_ADOBE, pdfFontSet, exceptions);
        }
        if (this.systemFontDir != null) {
            loaded |= this.loadFontsFromDirStr(this.systemFontDir, FONTS_SRC_SYSTEM, pdfFontSet, exceptions);
        }
        for (Exception e : exceptions) {
            this.log.warn("Error occurred in loading fonts", (Throwable)e);
        }
        if (!loaded) {
            throw new FontManagerException(1003, "NO FONTS were loaded at all");
        }
    }

    private boolean loadFontsFromDirStr(String fontDir, String srcFontType, PDFFontSet pdfFontSet, Set<Exception> exceptions) {
        boolean loaded = false;
        if (fontDir.lastIndexOf(PATH_SEP) != -1) {
            loaded = this.loadFontsFromMultiDirStr(fontDir, srcFontType, pdfFontSet, exceptions);
        } else {
            File fontDirectoryObj = new File(fontDir);
            if (fontDirectoryObj.exists()) {
                loaded = this.loadFontsDirectory(fontDirectoryObj, srcFontType, pdfFontSet);
            } else {
                FontManagerException fe = new FontManagerException(1002, "Null/Non-existent font directory : " + fontDir);
                exceptions.add(fe);
            }
        }
        return loaded;
    }

    private boolean loadFontsFromMultiDirStr(String fontDirs, String srcFontType, PDFFontSet pdfFontSet, Set<Exception> exceptions) {
        String[] fontDirsList;
        boolean loaded = false;
        for (String aFontDirsList : fontDirsList = fontDirs.split(PATH_SEP, 50)) {
            loaded |= this.loadFontsFromDirStr(aFontDirsList, srcFontType, pdfFontSet, exceptions);
        }
        return loaded;
    }

    private boolean loadFontsDirectory(File rootDir, String srcFontType, PDFFontSet pdfFontSet) {
        boolean added = false;
        if (rootDir != null) {
            this.log.debug("Loading {} fonts from directory {}", (Object)srcFontType, (Object)rootDir.getAbsoluteFile());
            Font[] fonts = this.loadFontsFromDir(rootDir, srcFontType);
            if (fonts != null) {
                added = this.addFontsToFontSet(fonts, srcFontType, pdfFontSet);
            }
        }
        return added;
    }

    private Font[] loadFontsFromDir(File rootDir, String srcFontType) {
        FontLoader loader = new FontLoader();
        ArrayList exceptionList = new ArrayList();
        ArrayList badURLs = new ArrayList();
        Font[] fonts = loader.load(rootDir, true, exceptionList, badURLs);
        int unsupported = 0;
        for (int ndx = 0; ndx < exceptionList.size(); ++ndx) {
            Exception e = (Exception)exceptionList.get(ndx);
            String bad = ((URL)badURLs.get(ndx)).getPath();
            if (e instanceof UnsupportedFontException) {
                if (srcFontType.equals(FONTS_SRC_SYSTEM)) {
                    ++unsupported;
                    this.log.warn("Unsupported System font : font [{}] not loaded.", (Object)bad);
                } else if (!bad.endsWith("zx______.pfb") && !bad.endsWith("zy______.pfb")) {
                    ++unsupported;
                    this.log.warn("Unsupported font : {} ", (Object)bad);
                }
            } else {
                this.log.warn("FontManager: Exception while loading font : " + bad, (Throwable)e);
            }
            this.fontStats.addBadUrl(bad);
        }
        if (unsupported > 0) {
            this.log.debug("Number of unsupported fonts: {} in directory : {}", (Object)unsupported, (Object)rootDir.getAbsolutePath());
        }
        return fonts;
    }

    private boolean addFontsToFontSet(Font[] fonts, String srcFontType, PDFFontSet pdfFontSet) {
        boolean fontsAdded = false;
        String familyName = null;
        TreeSet<String> nameSet = new TreeSet<String>();
        for (Font font : fonts) {
            try {
                CSS20FontDescription aFontDesc;
                CSS20FontDescription[] fontDesc = font.getCSS20FontDescription();
                if (fontDesc == null || fontDesc.length < 1) continue;
                familyName = null;
                CSS20FontDescription[] arr$ = fontDesc;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (familyName = (aFontDesc = arr$[i$]).getFamilyName()) == null; ++i$) {
                }
            }
            catch (FontEngineException fee) {
                this.log.debug("Exception while retrieving font description: ", (Object)fee.getMessage(), (Object)fee);
                continue;
            }
            try {
                pdfFontSet.addFont(font);
                if (!fontsAdded) {
                    fontsAdded = true;
                }
                if (familyName == null) continue;
                nameSet.add(familyName);
                this.fontStats.addFontInfo(srcFontType, font);
            }
            catch (PDFFontException cfe) {
                this.log.warn("Exception while adding font : " + familyName, (Throwable)cfe);
            }
        }
        if (this.log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("List of fonts of type " + srcFontType + " added to font set:");
            for (String name : nameSet) {
                pw.print("-- ");
                pw.print(name);
                pw.println();
            }
            this.log.debug(sw.toString());
        }
        return fontsAdded;
    }

    @Activate
    private void activate(Map<String, Object> config) throws IOException {
        Object[] systemFontDirs = OsgiUtil.toStringArray((Object)config.get(PROP_SYSTEM_FONT_DIR));
        String adobeFontDirPath = OsgiUtil.toString((Object)config.get(PROP_ADOBE_FONT_DIR), null);
        String customerFontDirPath = OsgiUtil.toString((Object)config.get(PROP_CUSTOMER_FONT_DIR), null);
        if (!ArrayUtils.isEmpty((Object[])systemFontDirs)) {
            this.systemFontDir = this.concatenateDirectoryList((String[])systemFontDirs, "System Font Dir");
        }
        if (StringUtils.isNotBlank((String)customerFontDirPath)) {
            customerFontDirPath = customerFontDirPath.trim();
            this.checkDirectory(customerFontDirPath, "Customer Font Dir");
            this.customerFontDir = new File(customerFontDirPath).getCanonicalPath();
        }
        if (StringUtils.isNotBlank((String)adobeFontDirPath)) {
            adobeFontDirPath = adobeFontDirPath.trim();
            this.checkDirectory(adobeFontDirPath, "Adobe Font Dir");
            this.adobeFontDir = new File(adobeFontDirPath).getCanonicalPath();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Using following directories for looking up fonts. Adobe Font Dir = {}, Customer Font Dir = {},System Font Dir = {}", new Object[]{this.adobeFontDir, this.customerFontDir, this.systemFontDir});
        }
    }

    private String concatenateDirectoryList(String[] fontDirs, String directoryType) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String dirPath : fontDirs) {
            if ((dirPath = dirPath.trim()).equals("")) continue;
            File directory = new File(dirPath);
            String message = null;
            if (!directory.exists()) {
                message = directory + " does not exist";
            } else if (!directory.isDirectory()) {
                message = directory + " is not a directory";
            }
            if (message != null) {
                errorMessages.add(message);
                continue;
            }
            sb.append(directory.getCanonicalPath()).append(';');
        }
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (!errorMessages.isEmpty()) {
            this.log.warn("Invalid directory path  specified for {}. Following paths found to be invalid {}", new Object[]{directoryType, errorMessages});
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private void checkDirectory(String directoryPath, String directoryType) {
        File directory = new File(directoryPath);
        String msgPrefix = "Invalid directory path specified for " + directoryType + ". ";
        if (!directory.exists()) {
            String message = msgPrefix + directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = msgPrefix + directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public String getSystemFontDirectory() {
        return this.systemFontDir;
    }

    @Override
    public String getAdobeServerFontDirectory() {
        return this.adobeFontDir;
    }

    @Override
    public String getCustomerFontDirectory() {
        return this.customerFontDir;
    }

    static class FontStats {
        Set<String> systemFontDetailsSet = new TreeSet<String>();
        Set<String> customerFontDetailsSet = new TreeSet<String>();
        Set<String> adobeFontDetailsSet = new TreeSet<String>();
        List<String> badFontsList = new ArrayList<String>();
        private Logger log = LoggerFactory.getLogger(FontStats.class);
        int fontCount = 0;
        String[] badFonts;
        String[] systemFontDetails;
        String[] customerFontDetails;
        String[] adobeFontDetails;

        FontStats() {
        }

        public void addFontInfo(String srcFontType, Font font) {
            if (FontManagerServiceImpl.FONTS_SRC_SYSTEM.equals(srcFontType)) {
                this.systemFontDetailsSet.add(this.getFontInfo(font));
            } else if (FontManagerServiceImpl.FONTS_SRC_ADOBE.equals(srcFontType)) {
                this.adobeFontDetailsSet.add(this.getFontInfo(font));
            } else {
                this.customerFontDetailsSet.add(this.getFontInfo(font));
            }
            ++this.fontCount;
        }

        private String getFontInfo(Font font) {
            CSS20FontDescription fd = this.getFontDesc(font);
            if (fd == null) {
                return null;
            }
            return String.format("%s, Style: %s, Variant: %s, Stretch: %s", fd.getFamilyName(), fd.getStyle(), fd.getVariant(), fd.getStretch());
        }

        private CSS20FontDescription getFontDesc(Font font) {
            try {
                CSS20FontDescription fontDescription = font.getPreferredCSS20FontDescription();
                if (fontDescription != null) {
                    return fontDescription;
                }
                CSS20FontDescription[] fontDescs = font.getCSS20FontDescription();
                if (fontDescs == null || fontDescs.length < 1) {
                    return null;
                }
                for (CSS20FontDescription aFontDesc : fontDescs) {
                    String familyName = aFontDesc.getFamilyName();
                    if (familyName == null) continue;
                    return aFontDesc;
                }
            }
            catch (InvalidFontException e) {
                this.log.debug("getFontDesc: Exception occured because of invalid font: ", (Throwable)e);
            }
            catch (UnsupportedFontException e) {
                this.log.debug("getFontDesc: Exception occured to unsupported font: ", (Throwable)e);
            }
            catch (FontLoadingException e) {
                this.log.debug("getFontDesc: Exception occured while loading font: ", (Throwable)e);
            }
            return null;
        }

        public void addBadUrl(String bad) {
            this.badFontsList.add(bad);
        }

        public void process() {
            this.systemFontDetails = this.systemFontDetailsSet.toArray(new String[this.systemFontDetailsSet.size()]);
            this.customerFontDetails = this.customerFontDetailsSet.toArray(new String[this.customerFontDetailsSet.size()]);
            this.adobeFontDetails = this.adobeFontDetailsSet.toArray(new String[this.adobeFontDetailsSet.size()]);
            this.badFonts = this.badFontsList.toArray(new String[this.badFontsList.size()]);
            this.systemFontDetailsSet = null;
            this.customerFontDetailsSet = null;
            this.adobeFontDetailsSet = null;
            this.badFontsList = null;
        }
    }
}

