/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.impl.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=false)
abstract class AbstractImageProcess
extends AbstractAssetWorkflowProcess {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String IMG_MIME_TYPE = "image/png";
    protected static final String IMG_EXT = ".png";

    AbstractImageProcess() {
    }

    protected abstract Layer processImage(Node var1, String[] var2) throws IOException, RepositoryException;

    protected abstract String getRenditionName(Layer var1, String[] var2);

    protected boolean isProcessable(Node asset) {
        return asset != null && !DamUtil.isThumbnail((Node)asset) && this.getMimetype(asset).startsWith("image/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer loadImage(Node asset) throws IOException, PathNotFoundException, RepositoryException {
        InputStream ins = AbstractImageProcess.getFileContent(asset);
        try {
            Layer layer = new Layer(ins);
            Object var5_4 = null;
            this.close(ins);
            return layer;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close(ins);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        FileOutputStream tmpOut;
        FileInputStream tmpIns;
        File tmpFile;
        block9: {
            String[] args = this.buildArguments(metaData);
            Session session = null;
            tmpFile = null;
            tmpIns = null;
            tmpOut = null;
            try {
                block8: {
                    try {
                        session = workflowSession.getSession();
                        Node asset = this.getNodeFromPayload(workItem, session);
                        if (this.isProcessable(asset)) {
                            this.log.info("execute: start [{}] for asset [{}].", (Object)this, (Object)this.safeGetPath(asset));
                            Node renditionFolder = this.getRenditionFolder(asset.getPath(), session);
                            if (renditionFolder == null) {
                                this.log.warn("execute: cannot process asset [{}] as the asset does not have the renditions folder", (Object)this.safeGetPath(asset));
                                Object var14_13 = null;
                                break block8;
                            }
                            Layer l = this.processImage(asset, args);
                            tmpFile = File.createTempFile("dam", ".process.tmp");
                            tmpOut = new FileOutputStream(tmpFile);
                            l.write(IMG_MIME_TYPE, 255.0, (OutputStream)tmpOut);
                            ((OutputStream)tmpOut).close();
                            tmpOut = null;
                            String renditionName = this.getRenditionName(l, args);
                            tmpIns = new FileInputStream(tmpFile);
                            AbstractImageProcess.createFileNode(renditionFolder, renditionName, tmpIns, IMG_MIME_TYPE);
                            break block9;
                        }
                        this.log.info("execute: cannot process asset [{}].", (Object)this.safeGetPath(asset));
                        break block9;
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error("execute: cannot process asset [{}], invalid configuration: ", (Object)workItem.getWorkflowData().getPayload().toString(), (Object)e);
                        Object var14_15 = null;
                        this.close(tmpIns);
                        this.close(tmpOut);
                        if (tmpFile == null) return;
                        if (!tmpFile.exists()) return;
                        if (tmpFile.delete()) return;
                        this.log.warn("execute: failed removing temporary file [{}] for asset [{}].", (Object)tmpFile, (Object)workItem.getWorkflowData().getPayload().toString());
                        return;
                    }
                    catch (Exception e) {
                        this.log.error("execute: error while processing asset [{}]: ", (Object)workItem.getWorkflowData().getPayload().toString(), (Object)e);
                        Object var14_16 = null;
                        this.close(tmpIns);
                        this.close(tmpOut);
                        if (tmpFile == null) return;
                        if (!tmpFile.exists()) return;
                        if (tmpFile.delete()) return;
                        this.log.warn("execute: failed removing temporary file [{}] for asset [{}].", (Object)tmpFile, (Object)workItem.getWorkflowData().getPayload().toString());
                        return;
                    }
                }
                this.close(tmpIns);
                this.close(tmpOut);
                if (tmpFile == null) return;
                if (!tmpFile.exists()) return;
                if (tmpFile.delete()) return;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.close(tmpIns);
                this.close(tmpOut);
                if (tmpFile == null) throw throwable;
                if (!tmpFile.exists()) throw throwable;
                if (tmpFile.delete()) throw throwable;
                this.log.warn("execute: failed removing temporary file [{}] for asset [{}].", (Object)tmpFile, (Object)workItem.getWorkflowData().getPayload().toString());
                throw throwable;
            }
            this.log.warn("execute: failed removing temporary file [{}] for asset [{}].", (Object)tmpFile, (Object)workItem.getWorkflowData().getPayload().toString());
            return;
        }
        Object var14_14 = null;
        this.close(tmpIns);
        this.close(tmpOut);
        if (tmpFile == null) return;
        if (!tmpFile.exists()) return;
        if (tmpFile.delete()) return;
        this.log.warn("execute: failed removing temporary file [{}] for asset [{}].", (Object)tmpFile, (Object)workItem.getWorkflowData().getPayload().toString());
    }

    abstract String[] buildArguments(MetaDataMap var1);

    private Node getRenditionFolder(String path, Session session) throws RepositoryException {
        AssetManager mgr = this.getAssetManager(session);
        Asset asset = mgr.getAssetForBinary(path);
        if (asset == null) {
            asset = mgr.createAssetForBinary(path, true);
        }
        if (asset == null && (asset = DamUtil.resolveToAsset((Resource)this.getResourceResolver(session).getResource(path))) == null) {
            return null;
        }
        return ((Node)asset.adaptTo(Node.class)).getNode("jcr:content/renditions");
    }

    private static void createFileNode(Node parent, String name, InputStream is, String mimeType) throws RepositoryException {
        if (parent.hasNode(name)) {
            Node content = parent.getNode(name + "/" + "jcr:content");
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:data", is);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.getSession().save();
        } else {
            Node file = parent.addNode(name, "nt:file");
            Node content = file.addNode("jcr:content", "nt:resource");
            AbstractImageProcess.setFileContent(content, is, mimeType);
            parent.getSession().save();
        }
    }

    private static void setFileContent(Node content, InputStream is, String mimeType) throws RepositoryException {
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:data", is);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
    }

    protected static InputStream getFileContent(Node asset) throws RepositoryException {
        Node content = asset.hasNode("jcr:content") ? asset.getNode("jcr:content") : asset;
        return content.getProperty("jcr:data").getStream();
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log.debug("close: error closing: ", (Throwable)e);
            }
        }
    }
}

