/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.impl.process;

import com.day.cq.dam.handler.impl.process.AbstractImageProcess;
import com.day.cq.dam.handler.impl.process.geometry.Geometry;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Resize Image"})
public class ResizeImageProcess
extends AbstractImageProcess {
    protected Layer processImage(Node asset, String[] args) throws IOException, RepositoryException {
        Dimension currentSize;
        Geometry geometry;
        Dimension2D newSize;
        Layer l = new Layer(this.loadImage(asset));
        if (args != null && args.length > 0 && (newSize = (geometry = Geometry.getInstance(args[0])).getSize(currentSize = new Dimension(l.getWidth(), l.getHeight()))) != null) {
            l.resize((int)newSize.getWidth(), (int)newSize.getHeight());
        }
        return l;
    }

    protected String getRenditionName(Layer l, String[] args) {
        String name = args.length > 1 && args[1].length() > 0 ? args[1] : args[0];
        return "cq5dam.resized." + name + ".png";
    }

    public String toString() {
        return "Resize Process";
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String area = (String)metaData.get(Arguments.AREA.name(), String.class);
        String width = (String)metaData.get(Arguments.WIDTH.name(), String.class);
        String height = (String)metaData.get(Arguments.HEIGHT.name(), String.class);
        if (StringUtils.isNotBlank((String)area)) {
            area = area + "@";
            arguments.add(area);
        } else if (StringUtils.isNotBlank((String)width) && StringUtils.isNotBlank((String)height)) {
            String sizingModeQualifier = this.getSizingModeQualifier((String)metaData.get(Arguments.SIZING_MODE.name(), String.class));
            StringBuilder builder = new StringBuilder();
            builder.append(width).append("x").append(height).append(sizingModeQualifier);
            arguments.add(builder.toString());
        } else {
            throw new IllegalArgumentException("metaData must contain either the AREA argument or the WIDTH and HEIGHT argument");
        }
        String renditionName = (String)metaData.get(Arguments.RENDITION_NAME.name(), String.class);
        if (StringUtils.isNotBlank((String)renditionName)) {
            arguments.add(renditionName);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private String getSizingModeQualifier(String sizingMode) {
        if (sizingMode == null) {
            return SizingModes.MAX_SIZE.getQualifier();
        }
        if (sizingMode.equals(SizingModes.GROW_ONLY.name())) {
            return SizingModes.GROW_ONLY.getQualifier();
        }
        if (sizingMode.equals(SizingModes.SHRINK_ONLY.name())) {
            return SizingModes.SHRINK_ONLY.getQualifier();
        }
        if (sizingMode.equals(SizingModes.FORCE.name())) {
            return SizingModes.FORCE.getQualifier();
        }
        if (sizingMode.equals(SizingModes.MIN_SIZE.name())) {
            return SizingModes.MIN_SIZE.getQualifier();
        }
        return SizingModes.MAX_SIZE.getQualifier();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizingModes {
        SHRINK_ONLY("<"),
        GROW_ONLY(">"),
        MIN_SIZE("^"),
        FORCE("!"),
        MAX_SIZE("");

        private final String qualifier;

        private SizingModes(String qualifier) {
            this.qualifier = qualifier;
        }

        public String getQualifier() {
            return this.qualifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS,
        RENDITION_NAME,
        WIDTH,
        HEIGHT,
        SIZING_MODE,
        AREA;

    }
}

