/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.impl.process.geometry;

import com.day.cq.dam.handler.impl.process.geometry.GeometryBehaviour;
import java.awt.geom.Dimension2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Geometry {
    static final Pattern GEOMETRY_SPEC_PATTERN = Pattern.compile("((\\d+)([%@])?)?(x(\\d+)([%^!><])?)?");
    private final int width;
    private final int height;

    public static Geometry getInstance(String specification) {
        if (specification != null && specification.length() > 0) {
            Matcher m = GEOMETRY_SPEC_PATTERN.matcher(specification);
            if (m.matches() && m.groupCount() == 6) {
                GeometryBehaviour behaviour;
                int height;
                int width;
                boolean widthScale = false;
                boolean area = false;
                if (m.group(1) != null) {
                    width = Integer.parseInt(m.group(2));
                    String g3 = m.group(3);
                    if (g3 != null) {
                        widthScale = '%' == g3.charAt(0);
                        area = '@' == g3.charAt(0);
                    }
                } else {
                    width = -1;
                }
                if (m.group(4) != null) {
                    if (area) {
                        throw Geometry.failure(specification, "Width cannot be specified if pixel size is defined");
                    }
                    height = Integer.parseInt(m.group(5));
                    String heightSpec = m.group(6);
                    if (heightSpec == null) {
                        behaviour = widthScale ? GeometryBehaviour.SCALE : GeometryBehaviour.MAX_SIZE;
                    } else {
                        switch (heightSpec.charAt(0)) {
                            case '%': {
                                behaviour = GeometryBehaviour.SCALE;
                                break;
                            }
                            case '^': {
                                behaviour = GeometryBehaviour.MIN_SIZE;
                                break;
                            }
                            case '!': {
                                behaviour = GeometryBehaviour.FORCE;
                                break;
                            }
                            case '<': {
                                behaviour = GeometryBehaviour.GROW;
                                break;
                            }
                            case '>': {
                                behaviour = GeometryBehaviour.SHRINK;
                                break;
                            }
                            default: {
                                behaviour = GeometryBehaviour.MAX_SIZE;
                            }
                        }
                    }
                    if (widthScale && behaviour != GeometryBehaviour.SCALE) {
                        throw Geometry.failure(specification, "If width is scaled, height must also be scaled");
                    }
                    if (width < 0 && behaviour != GeometryBehaviour.MAX_SIZE) {
                        throw Geometry.failure(specification, "If width is not specified, no special size flag may be set for the height");
                    }
                } else {
                    behaviour = widthScale ? GeometryBehaviour.SCALE : (area ? GeometryBehaviour.AREA : GeometryBehaviour.MAX_SIZE);
                    height = -1;
                }
                return behaviour.getGeometry(width, height);
            }
            throw Geometry.failure(specification, "Specification cannot be parsed");
        }
        return GeometryBehaviour.SCALE.getGeometry(100, 100);
    }

    protected Geometry(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public abstract Dimension2D getSize(Dimension2D var1);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static IllegalArgumentException failure(String specification, String reason) {
        return new IllegalArgumentException("Illegal Geometry '" + specification + "': " + reason);
    }
}

