/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.impl.process.geometry;

import com.day.cq.dam.handler.impl.process.geometry.AreaGeometry;
import com.day.cq.dam.handler.impl.process.geometry.ForceGeometry;
import com.day.cq.dam.handler.impl.process.geometry.Geometry;
import com.day.cq.dam.handler.impl.process.geometry.GrowGeometry;
import com.day.cq.dam.handler.impl.process.geometry.MaxSizeGeometry;
import com.day.cq.dam.handler.impl.process.geometry.MinSizeGeometry;
import com.day.cq.dam.handler.impl.process.geometry.ScaleGeometry;
import com.day.cq.dam.handler.impl.process.geometry.ShrinkGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum GeometryBehaviour {
    SCALE{

        public Geometry getGeometry(int width, int height) {
            return new ScaleGeometry(width, height);
        }
    }
    ,
    MAX_SIZE{

        public Geometry getGeometry(int width, int height) {
            return new MaxSizeGeometry(width, height);
        }
    }
    ,
    MIN_SIZE{

        public Geometry getGeometry(int width, int height) {
            return new MinSizeGeometry(width, height);
        }
    }
    ,
    FORCE{

        public Geometry getGeometry(int width, int height) {
            return new ForceGeometry(width, height);
        }
    }
    ,
    GROW{

        public Geometry getGeometry(int width, int height) {
            return new GrowGeometry(width, height);
        }
    }
    ,
    SHRINK{

        public Geometry getGeometry(int width, int height) {
            return new ShrinkGeometry(width, height);
        }
    }
    ,
    AREA{

        public Geometry getGeometry(int width, int height) {
            return new AreaGeometry(width, height);
        }
    };


    public abstract Geometry getGeometry(int var1, int var2);
}

