/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.impl.process.geometry;

import com.day.cq.dam.handler.impl.process.geometry.AbstractGeometry;
import java.awt.geom.Dimension2D;

public class MaxSizeGeometry
extends AbstractGeometry {
    public MaxSizeGeometry(int width, int height) {
        super(width, height);
    }

    public Dimension2D getSize(Dimension2D size) {
        if (!(this.getWidth() >= 0 && this.getWidth() != (int)size.getWidth() || this.getHeight() >= 0 && this.getHeight() != (int)size.getHeight())) {
            return null;
        }
        double widthScale = this.getScaleFactor(this.getWidth(), size.getWidth());
        double heightScale = this.getScaleFactor(this.getHeight(), size.getHeight());
        double scale = this.selectFactor(widthScale, heightScale);
        double newWidth = this.scaleAndRound(size.getWidth(), scale);
        double newHeight = this.scaleAndRound(size.getHeight(), scale);
        return this.cloneDimension(size, newWidth, newHeight);
    }

    protected double getScaleFactor(double dest, double source) {
        return dest / source;
    }

    protected double selectFactor(double widthScale, double heightScale) {
        return widthScale > 0.0 && (widthScale < heightScale || heightScale < 0.0) ? widthScale : heightScale;
    }

    protected double scaleAndRound(double length, double scale) {
        return Math.floor(length * scale + 0.5);
    }
}

