/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.epub;

import com.day.cq.dam.handler.standard.epub.NonCloseableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPubExtractor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> extractMetadata(InputStream in) throws Exception {
        ZipInputStream zin;
        block8: {
            Map<String, String> map;
            block7: {
                zin = null;
                try {
                    zin = new ZipInputStream(in);
                    ZipEntry e = null;
                    while ((e = zin.getNextEntry()) != null) {
                        if (!e.getName().endsWith(".opf")) continue;
                        map = this.readMetadata(zin);
                        Object var6_6 = null;
                        if (zin == null) return map;
                        break block7;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (zin == null) throw throwable;
                    zin.close();
                    throw throwable;
                }
            }
            zin.close();
            return map;
        }
        Object var6_7 = null;
        if (zin == null) return null;
        zin.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] extractImage(InputStream in, String href) throws Exception {
        ZipInputStream zin;
        block8: {
            byte[] byArray;
            block7: {
                zin = null;
                try {
                    zin = new ZipInputStream(in);
                    ZipEntry e = null;
                    while ((e = zin.getNextEntry()) != null) {
                        if (!e.getName().endsWith(href)) continue;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)zin, (OutputStream)out);
                        byArray = out.toByteArray();
                        Object var8_8 = null;
                        if (zin == null) return byArray;
                        break block7;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (zin == null) throw throwable;
                    zin.close();
                    throw throwable;
                }
            }
            zin.close();
            return byArray;
        }
        Object var8_9 = null;
        if (zin == null) return null;
        zin.close();
        return null;
    }

    protected Map<String, String> readMetadata(InputStream in) throws Exception {
        HashMap<String, String> rv = new HashMap<String, String>();
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        Document doc = builder.parse(new NonCloseableInputStream(in));
        String covername = null;
        NodeList ls = doc.getFirstChild().getChildNodes();
        for (int i = 0; i < ls.getLength(); ++i) {
            String name;
            Node m;
            int z;
            NodeList mls;
            Node n = ls.item(i);
            if (n.getNodeType() == 1 && n.getLocalName().equals("metadata")) {
                mls = n.getChildNodes();
                for (z = 0; z < mls.getLength(); ++z) {
                    m = mls.item(z);
                    if (m.getNodeType() == 1 && m.getLocalName().equals("meta")) {
                        name = ((Element)m).getAttribute("name");
                        if (!"cover".equals(name)) continue;
                        covername = ((Element)m).getAttribute("content");
                        continue;
                    }
                    if (m.getNodeType() != 1) continue;
                    String mname = m.getLocalName();
                    String mval = m.getTextContent();
                    rv.put(mname, mval);
                }
            }
            if (n.getNodeType() != 1 || !n.getLocalName().equals("manifest")) continue;
            mls = n.getChildNodes();
            for (z = 0; z < mls.getLength(); ++z) {
                m = mls.item(z);
                if (m.getNodeType() != 1 || !m.getLocalName().equals("item") || !(name = ((Element)m).getAttribute("id")).equals(covername)) continue;
                rv.put("_coverhref", ((Element)m).getAttribute("href"));
            }
        }
        return rv;
    }
}

