/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.keynote;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.standard.keynote.KeynotePresentation;
import com.day.cq.dam.handler.standard.keynote.KeynoteSlide;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(inherit=true, metatype=false)
@Service
public class KeynoteHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(KeynoteHandler.class);
    public static final String[] CONTENT_MIMETYPES = new String[]{"application/x-iWork-keynote-sffkey", "application/x-iwork-keynote-sffkey", "application/vnd.apple.keynote"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block6: {
            metadata = new ExtractedMetadata();
            log.debug("extractMetadata: importing asset [{}]", (Object)asset.getPath());
            InputStream is = asset.getOriginal().getStream();
            try {
                try {
                    KeynotePresentation preso = new KeynotePresentation(is);
                    metadata.setMetaDataProperty("tiff:ImageLength", (Object)preso.getHeight());
                    metadata.setMetaDataProperty("tiff:ImageWidth", (Object)preso.getWidth());
                    metadata.setMetaDataProperty("Slide Count", (Object)preso.getSlides().size());
                }
                catch (SAXException e) {
                    log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
                    Object var6_9 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    break block6;
                }
                catch (IOException e) {
                    log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
                    Object var6_10 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    break block6;
                }
                catch (ParserConfigurationException e) {
                    log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
                    Object var6_11 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    break block6;
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    public boolean canHandleSubAssets() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets = new ArrayList<String>();
        if (asset.isSubAsset()) {
            return subAssets;
        }
        InputStream is = asset.getOriginal().getStream();
        InputStream isp = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream ois = null;
        try {
            try {
                KeynotePresentation preso = new KeynotePresentation(is);
                List<KeynoteSlide> slides = preso.getSlides();
                boolean oldBatchMode = asset.isBatchMode();
                asset.setBatchMode(true);
                int i = 0;
                for (KeynoteSlide slide : slides) {
                    if (slide.isHidden()) continue;
                    ++i;
                    isp = asset.getOriginal().getStream();
                    KeynotePresentation p = new KeynotePresentation(isp);
                    List<KeynoteSlide> pslides = p.getSlides();
                    for (KeynoteSlide s : pslides) {
                        if (slide.getId().equals(s.getId())) continue;
                        p.removeSlide(s);
                    }
                    out = new ByteArrayOutputStream();
                    p.save(out);
                    ois = new ByteArrayInputStream(out.toByteArray());
                    String fileName = "page" + (i + 1) + ".key";
                    Asset subAsset = asset.addSubAsset(fileName, CONTENT_MIMETYPES[0], (InputStream)ois);
                    subAssets.add(subAsset.getPath());
                }
                ((Node)asset.adaptTo(Node.class)).getSession().save();
                asset.setBatchMode(oldBatchMode);
            }
            catch (Exception e) {
                log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                Object var18_19 = null;
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(isp);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(ois);
                return subAssets;
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(isp);
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(ois);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)isp);
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(ois);
        return subAssets;
    }

    public String[] getMimeTypes() {
        return CONTENT_MIMETYPES;
    }

    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        InputStream is = rendition.getStream();
        try {
            try {
                BufferedImage bufferedImage;
                KeynotePresentation preso = new KeynotePresentation(is);
                FileOutputStream itout = null;
                FileInputStream iis = null;
                File imageTmpFile = null;
                try {
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    Layer layer = new Layer(preso.getThumbnail());
                    itout = FileUtils.openOutputStream((File)imageTmpFile);
                    layer.write("image/png", 1.0, (OutputStream)itout);
                    iis = FileUtils.openInputStream((File)imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, dim).getImage();
                    Object var11_12 = null;
                }
                catch (Exception e) {
                    try {
                        log.info("getImage: cannot extract image for file [{}]: ", (Object)rendition.getPath(), (Object)e);
                        Object var11_13 = null;
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly((OutputStream)itout);
                        FileUtils.deleteQuietly((File)imageTmpFile);
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly(itout);
                        FileUtils.deleteQuietly((File)imageTmpFile);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)iis);
                IOUtils.closeQuietly((OutputStream)itout);
                FileUtils.deleteQuietly((File)imageTmpFile);
                Object var13_15 = null;
                IOUtils.closeQuietly((InputStream)is);
                return bufferedImage;
                Object var13_16 = null;
            }
            catch (Exception e) {
                log.warn("getImage: error while creating image from Keynote [{}]: ", (Object)rendition.getPath(), (Object)e);
                Object var13_17 = null;
                IOUtils.closeQuietly((InputStream)is);
                return null;
            }
            IOUtils.closeQuietly((InputStream)is);
            return null;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
    }
}

