/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.psd;

import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.xmp.XMPHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.image.Layer;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageReader;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class PsdHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PsdHandler.class);
    public static final String PHOTOSHOP_MIMETYPE_1 = "application/x-photoshop";
    public static final String PHOTOSHOP_MIMETYPE_2 = "application/photoshop";
    public static final String PHOTOSHOP_MIMETYPE_3 = "image/vnd.adobe.photoshop";
    public static final String PHOTOSHOP_MIMETYPE_4 = "application/vnd.adobe.photoshop";
    @Reference(policy=ReferencePolicy.STATIC)
    protected XMPHandler xmpHandler;

    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        BufferedImage bufferedImage;
        InputStream is = rendition.getStream();
        boolean debug = log.isDebugEnabled();
        try {
            try {
                PSDImageReader reader = new PSDImageReader(null);
                ImageInputStream stream = ImageIO.createImageInputStream(is);
                reader.setInput(stream);
                reader.readHeader();
                if (debug) {
                    log.debug("imageReader.mHeader: " + reader.getHeader());
                }
                reader.readImageResources(true);
                if (debug) {
                    log.debug("imageReader.mImageResources: " + reader.getImageResources());
                }
                reader.readLayerAndMaskInfo(true);
                if (debug) {
                    log.debug("imageReader.mLayerInfo: " + reader.getLayerInfo());
                    log.debug("imageReader.mGlobalLayerMask: " + reader.getGlobalLayerMask());
                }
                long start = System.currentTimeMillis();
                ImageReadParam param = new ImageReadParam();
                BufferedImage image = reader.read(0, param);
                if (debug) {
                    log.debug("time: " + (System.currentTimeMillis() - start));
                    log.debug("image: " + image);
                }
                if (image.getColorModel().getColorSpace().getType() == 9) {
                    try {
                        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1000), null);
                        image = op.filter(image, new BufferedImage(image.getWidth(), image.getHeight(), 7));
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                    }
                    if (debug) {
                        log.debug("time: " + (System.currentTimeMillis() - start));
                        log.debug("image: " + image);
                    }
                }
                FileOutputStream itout = null;
                FileInputStream iis = null;
                File imageTmpFile = null;
                try {
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    Layer layer = new Layer(image);
                    itout = FileUtils.openOutputStream((File)imageTmpFile);
                    layer.write("image/png", 1.0, (OutputStream)itout);
                    iis = FileUtils.openInputStream((File)imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, dim).getImage();
                    Object var17_17 = null;
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    IOUtils.closeQuietly(iis);
                    IOUtils.closeQuietly(itout);
                    FileUtils.deleteQuietly((File)imageTmpFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)iis);
                IOUtils.closeQuietly((OutputStream)itout);
                FileUtils.deleteQuietly((File)imageTmpFile);
                Object var19_19 = null;
            }
            catch (Exception e) {
                log.warn("getImage: error while getting image for PSD [{}]: ", (Object)rendition.getPath(), (Object)e);
                Object var19_20 = null;
                IOUtils.closeQuietly((InputStream)is);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block9: {
            metadata = new ExtractedMetadata();
            InputStream is = asset.getOriginal().getStream();
            try {
                try {
                    PSDImageReader reader = new PSDImageReader(null);
                    ImageInputStream stream = ImageIO.createImageInputStream(is);
                    reader.setInput(stream);
                    reader.readHeader();
                    PSDHeader header = reader.getHeader();
                    metadata.setMetaDataProperty("tiff:ImageWidth", (Object)header.getWidth());
                    metadata.setMetaDataProperty("tiff:ImageLength", (Object)header.getHeight());
                    this.setMimetype(metadata, asset);
                }
                catch (IOException e) {
                    log.error("I/O error while getting metadata", (Throwable)e);
                    Object var8_10 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    break block9;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        ByteArrayInputStream xmps = null;
        try {
            try {
                XMPMeta xmpMeta = this.xmpHandler.readXmp(asset);
                xmps = new ByteArrayInputStream(XMPMetaFactory.serializeToBuffer((XMPMeta)xmpMeta, null));
                metadata.setXmp((InputStream)xmps);
            }
            catch (Exception e) {
                log.error("Cannot extract metadata ", (Throwable)e);
                Object var10_14 = null;
                IOUtils.closeQuietly(xmps);
                return metadata;
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            IOUtils.closeQuietly(xmps);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xmps);
        return metadata;
    }

    public String[] getMimeTypes() {
        return new String[]{PHOTOSHOP_MIMETYPE_1, PHOTOSHOP_MIMETYPE_2, PHOTOSHOP_MIMETYPE_3, PHOTOSHOP_MIMETYPE_4};
    }

    protected void bindXmpHandler(XMPHandler xMPHandler) {
        this.xmpHandler = xMPHandler;
    }

    protected void unbindXmpHandler(XMPHandler xMPHandler) {
        if (this.xmpHandler == xMPHandler) {
            this.xmpHandler = null;
        }
    }
}

