/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.zip;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.image.Font;
import com.day.image.Layer;
import com.day.image.font.AbstractFont;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class ZipHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(ZipHandler.class);
    public static final String JAR_MIME_TYPE = "application/java-archive";
    public static final String ZIP_MIME_TYPE = "application/zip";
    public static final String[] MIME_TYPES = new String[]{"application/java-archive", "application/zip"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        log.debug("extractMetadata: start extracting asset [{}]", (Object)asset.getPath());
        InputStream is = asset.getOriginal().getStream();
        ZipInputStream zis = new ZipInputStream(is);
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    buffer.append(entry.getName()).append('\n');
                    ++count;
                }
                zis.closeEntry();
            }
            metadata.setMetaDataProperty("Content", (Object)buffer.toString());
            metadata.setMetaDataProperty("File Count", (Object)count);
        }
        catch (IOException e) {
            log.warn("extractMetadata: error while reading ZIP archive [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        catch (IllegalArgumentException iae) {
            log.warn("extractMetadata: error while reading ZIP entry [{}]: ", (Object)asset.getPath(), (Object)iae);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    public BufferedImage getImage(Rendition rendition) throws IOException {
        ExtractedMetadata metadata = this.extractMetadata(rendition.getAsset());
        String text = (String)metadata.getMetaDataProperty("Content");
        if (text != null && text.length() > 0) {
            Layer layer = new Layer(500, 600, (Paint)Color.WHITE);
            layer.setPaint((Paint)Color.black);
            Font font = new Font("Arial", 12);
            String displayText = this.getDisplayText(text, 600, 12);
            layer.drawText(10, 10, 500, 600, displayText, (AbstractFont)font, 0, 0.0, 0);
            layer.crop((Rectangle2D)new Rectangle(510, 600));
            return layer.getImage();
        }
        return null;
    }

    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    private String getDisplayText(String text, int height, int fontheight) {
        String trimmedText = text.trim();
        int numOfLines = height / fontheight;
        String[] lines = trimmedText.split("\n");
        if (lines.length <= numOfLines) {
            return trimmedText;
        }
        String cutText = "";
        for (int i = 0; i < numOfLines; ++i) {
            cutText = cutText + lines[i] + "\n";
        }
        return cutText;
    }
}

