/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDColorData {
    final byte[] mColors;
    private IndexColorModel mColorModel;

    PSDColorData(ImageInputStream pInput) throws IOException {
        int length = pInput.readInt();
        if (length == 0) {
            throw new IIOException("No palette information in PSD");
        }
        if (length % 3 != 0) {
            throw new IIOException("Wrong palette information in PSD");
        }
        this.mColors = new byte[length];
        pInput.readFully(this.mColors);
    }

    IndexColorModel getIndexColorModel() {
        if (this.mColorModel == null) {
            int[] rgb = this.toInterleavedRGB(this.mColors);
            this.mColorModel = new InverseColorMapIndexColorModel(8, rgb.length, rgb, 0, false, -1, 0);
        }
        return this.mColorModel;
    }

    private int[] toInterleavedRGB(byte[] pColors) {
        int[] rgb = new int[pColors.length / 3];
        for (int i = 0; i < rgb.length; ++i) {
            int r = pColors[i] & 0xFF;
            int g = pColors[rgb.length + i] & 0xFF;
            int b = pColors[2 * rgb.length + i] & 0xFF;
            rgb[i] = r << 16 | g << 8 | b;
        }
        return rgb;
    }
}

