/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDDisplayInfo
extends PSDImageResource {
    private int mColorSpace;
    private short[] mColors;
    private short mOpacity;
    private byte mKind;

    PSDDisplayInfo(short pId, ImageInputStream pInput) throws IOException {
        super(pId, pInput);
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        if (this.mSize % 14L != 0L) {
            throw new IIOException("Display info length expected to be mod 14: " + this.mSize);
        }
        this.mColorSpace = pInput.readShort();
        this.mColors = new short[4];
        this.mColors[0] = pInput.readShort();
        this.mColors[1] = pInput.readShort();
        this.mColors[2] = pInput.readShort();
        this.mColors[3] = pInput.readShort();
        this.mOpacity = pInput.readShort();
        this.mKind = pInput.readByte();
        pInput.readByte();
        pInput.skipBytes(this.mSize - 14L);
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        builder.append(", ColorSpace: ").append(this.mColorSpace);
        builder.append(", Colors: {");
        builder.append(this.mColors[0]);
        builder.append(", ");
        builder.append(this.mColors[1]);
        builder.append(", ");
        builder.append(this.mColors[2]);
        builder.append(", ");
        builder.append(this.mColors[3]);
        builder.append("}, Opacity: ").append(this.mOpacity);
        builder.append(", Kind: ").append(this.kind(this.mKind));
        builder.append("]");
        return builder.toString();
    }

    private String kind(byte pKind) {
        switch (pKind) {
            case 0: {
                return "selected";
            }
            case 1: {
                return "protected";
            }
        }
        return "unknown kind: " + Integer.toHexString(pKind & 0xFF);
    }
}

