/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

final class PSDEXIF1Data
extends PSDImageResource {
    protected Directory mDirectory;

    PSDEXIF1Data(short pId, ImageInputStream pInput) throws IOException {
        super(pId, pInput);
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(IIOUtil.createStreamAdapter((ImageInputStream)pInput, (long)this.mSize));
        byte[] bom = new byte[2];
        stream.readFully(bom);
        if (bom[0] == 73 && bom[1] == 73) {
            stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (bom[0] != 77 || bom[1] != 77) {
            throw new IIOException(String.format("Invalid byte order marker '%s'", StringUtil.decode((byte[])bom, (int)0, (int)bom.length, (String)"ASCII")));
        }
        if (stream.readUnsignedShort() != 42) {
            throw new IIOException("Wrong TIFF magic in EXIF data.");
        }
        long directoryOffset = stream.readUnsignedInt();
        this.mDirectory = Directory.read(stream, directoryOffset);
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        builder.append(", ").append(this.mDirectory);
        builder.append("]");
        return builder.toString();
    }

    private static class Entry {
        private static final int EXIF_IFD = 34665;
        private static final String[] TYPE_NAMES = new String[]{"BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};
        private static final int[] TYPE_LENGTHS = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
        private int mTag;
        private short mType;
        private int mCount;
        private long mValueOffset;
        private Object mValue;

        private Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Entry read(ImageInputStream pInput) throws IOException {
            Entry entry = new Entry();
            entry.mTag = pInput.readUnsignedShort();
            entry.mType = pInput.readShort();
            entry.mCount = pInput.readInt();
            if (entry.mTag == 34665) {
                long offset = pInput.readUnsignedInt();
                pInput.mark();
                try {
                    entry.mValue = Directory.read(pInput, offset);
                }
                finally {
                    pInput.reset();
                }
            } else {
                int valueLength = entry.getValueLength();
                if (valueLength > 0 && valueLength <= 4) {
                    entry.readValueInLine(pInput);
                    pInput.skipBytes(4 - valueLength);
                } else {
                    entry.mValueOffset = pInput.readUnsignedInt();
                    entry.readValue(pInput);
                }
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readValue(ImageInputStream pInput) throws IOException {
            long pos = pInput.getStreamPosition();
            try {
                pInput.seek(this.mValueOffset);
                this.readValueInLine(pInput);
            }
            finally {
                pInput.seek(pos);
            }
        }

        private void readValueInLine(ImageInputStream pInput) throws IOException {
            this.mValue = Entry.readValueDirect(pInput, this.mType, this.mCount);
        }

        private static Object readValueDirect(ImageInputStream pInput, short pType, int pCount) throws IOException {
            switch (pType) {
                case 2: {
                    byte[] ascii = new byte[pCount];
                    pInput.readFully(ascii);
                    return StringUtil.decode((byte[])ascii, (int)0, (int)ascii.length, (String)"ASCII");
                }
                case 1: {
                    if (pCount == 1) {
                        return pInput.readUnsignedByte();
                    }
                }
                case 6: {
                    if (pCount == 1) {
                        return pInput.readByte();
                    }
                }
                case 7: {
                    byte[] bytes = new byte[pCount];
                    pInput.readFully(bytes);
                    return bytes;
                }
                case 3: {
                    if (pCount == 1) {
                        return pInput.readUnsignedShort();
                    }
                }
                case 8: {
                    if (pCount == 1) {
                        return pInput.readShort();
                    }
                    short[] shorts = new short[pCount];
                    pInput.readFully(shorts, 0, shorts.length);
                    return shorts;
                }
                case 4: {
                    if (pCount == 1) {
                        return pInput.readUnsignedInt();
                    }
                }
                case 9: {
                    if (pCount == 1) {
                        return pInput.readInt();
                    }
                    int[] ints = new int[pCount];
                    pInput.readFully(ints, 0, ints.length);
                    return ints;
                }
                case 11: {
                    if (pCount == 1) {
                        return Float.valueOf(pInput.readFloat());
                    }
                    float[] floats = new float[pCount];
                    pInput.readFully(floats, 0, floats.length);
                    return floats;
                }
                case 12: {
                    if (pCount == 1) {
                        return pInput.readDouble();
                    }
                    double[] doubles = new double[pCount];
                    pInput.readFully(doubles, 0, doubles.length);
                    return doubles;
                }
                case 5: {
                    if (pCount == 1) {
                        return (double)pInput.readUnsignedInt() / (double)pInput.readUnsignedInt();
                    }
                    double[] rationals = new double[pCount];
                    for (int i = 0; i < rationals.length; ++i) {
                        rationals[i] = (double)pInput.readUnsignedInt() / (double)pInput.readUnsignedInt();
                    }
                    return rationals;
                }
                case 10: {
                    if (pCount == 1) {
                        return (double)pInput.readInt() / (double)pInput.readInt();
                    }
                    double[] srationals = new double[pCount];
                    for (int i = 0; i < srationals.length; ++i) {
                        srationals[i] = (double)pInput.readInt() / (double)pInput.readInt();
                    }
                    return srationals;
                }
            }
            throw new IIOException(String.format("Unknown EXIF type '%s'", pType));
        }

        private int getValueLength() {
            if (this.mType > 0 && this.mType <= TYPE_LENGTHS.length) {
                return TYPE_LENGTHS[this.mType - 1] * this.mCount;
            }
            return -1;
        }

        private String getTypeName() {
            if (this.mType > 0 && this.mType <= TYPE_NAMES.length) {
                return TYPE_NAMES[this.mType - 1];
            }
            return "Unknown type";
        }

        public String toString() {
            return String.format("0x%04x: %s (%s, %d)", this.mTag, this.getValueAsString(), this.getTypeName(), this.mCount);
        }

        public String getValueAsString() {
            if (this.mValue instanceof String) {
                return String.format("\"%s\"", this.mValue);
            }
            if (this.mValue != null && this.mValue.getClass().isArray()) {
                Class<?> type = this.mValue.getClass().getComponentType();
                if (Byte.TYPE == type) {
                    return Arrays.toString((byte[])this.mValue);
                }
                if (Short.TYPE == type) {
                    return Arrays.toString((short[])this.mValue);
                }
                if (Integer.TYPE == type) {
                    return Arrays.toString((int[])this.mValue);
                }
                if (Float.TYPE == type) {
                    return Arrays.toString((float[])this.mValue);
                }
                if (Double.TYPE == type) {
                    return Arrays.toString((double[])this.mValue);
                }
            }
            return String.valueOf(this.mValue);
        }
    }

    private static class Directory {
        List<Entry> mEntries = new ArrayList<Entry>();

        private Directory() {
        }

        public static Directory read(ImageInputStream pInput, long pOffset) throws IOException {
            Directory directory = new Directory();
            pInput.seek(pOffset);
            int entryCount = pInput.readUnsignedShort();
            for (int i = 0; i < entryCount; ++i) {
                directory.mEntries.add(Entry.read(pInput));
            }
            long nextOffset = pInput.readUnsignedInt();
            if (nextOffset != 0L) {
                Directory next = Directory.read(pInput, nextOffset);
                directory.mEntries.addAll(next.mEntries);
            }
            return directory;
        }

        public String toString() {
            return String.format("Directory%s", this.mEntries);
        }
    }
}

