/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public class PSDHeader {
    final short mChannels;
    final int mWidth;
    final int mHeight;
    final short mBits;
    final short mMode;

    PSDHeader(ImageInputStream pInput) throws IOException {
        int signature = pInput.readInt();
        if (signature != 943870035) {
            throw new IIOException("Not a PSD document, expected signature \"8BPS\": \"" + PSDUtil.intToStr(signature) + "\" (0x" + Integer.toHexString(signature) + ")");
        }
        int version = pInput.readUnsignedShort();
        switch (version) {
            case 1: {
                break;
            }
            case 2: {
                throw new IIOException("Photoshop Large Document Format (PSB) not supported yet.");
            }
            default: {
                throw new IIOException(String.format("Unknown PSD version, expected 1 or 2: 0x%08x", version));
            }
        }
        byte[] reserved = new byte[6];
        pInput.readFully(reserved);
        this.mChannels = pInput.readShort();
        this.mHeight = pInput.readInt();
        this.mWidth = pInput.readInt();
        this.mBits = pInput.readShort();
        this.mMode = pInput.readShort();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[Channels: ");
        builder.append(this.mChannels);
        builder.append(", width: ");
        builder.append(this.mWidth);
        builder.append(", height: ");
        builder.append(this.mHeight);
        builder.append(", depth: ");
        builder.append(this.mBits);
        builder.append(", mode: ");
        builder.append(this.mMode);
        switch (this.mMode) {
            case 0: {
                builder.append(" (Monochrome)");
                break;
            }
            case 1: {
                builder.append(" (Grayscale)");
                break;
            }
            case 2: {
                builder.append(" (Indexed)");
                break;
            }
            case 3: {
                builder.append(" (RGB)");
                break;
            }
            case 4: {
                builder.append(" (CMYK)");
                break;
            }
            case 7: {
                builder.append(" (Multi channel)");
                break;
            }
            case 8: {
                builder.append(" (Duotone)");
                break;
            }
            case 9: {
                builder.append(" (Lab color)");
                break;
            }
            default: {
                builder.append(" (Unkown mode)");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

