/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.psd.CMYKColorSpace;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSDImageReader
extends ImageReaderBase {
    private PSDHeader mHeader;
    private PSDColorData mColorData;
    private List<PSDImageResource> mImageResources;
    private PSDGlobalLayerMask mGlobalLayerMask;
    private List<PSDLayerInfo> mLayerInfo;
    private ICC_ColorSpace mColorSpace;

    public PSDImageReader(ImageReaderSpi pOriginatingProvider) {
        super(pOriginatingProvider);
    }

    protected void resetMembers() {
        this.mHeader = null;
        this.mColorData = null;
        this.mImageResources = null;
        this.mColorSpace = null;
    }

    public PSDHeader getHeader() {
        return this.mHeader;
    }

    public List<PSDImageResource> getImageResources() {
        return Collections.unmodifiableList(this.mImageResources);
    }

    public List<PSDLayerInfo> getLayerInfo() {
        return Collections.unmodifiableList(this.mLayerInfo);
    }

    public PSDGlobalLayerMask getGlobalLayerMask() {
        return this.mGlobalLayerMask;
    }

    public int getWidth(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        return this.mHeader.mWidth;
    }

    public int getHeight(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        return this.mHeader.mHeight;
    }

    public ImageTypeSpecifier getRawImageType(int pIndex) throws IOException {
        return this.getRawImageTypeInternal(pIndex);
    }

    private ImageTypeSpecifier getRawImageTypeInternal(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        switch (this.mHeader.mMode) {
            case 0: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 1) {
                    return ImageTypeSpecifier.createFromBufferedImageType(12);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Monochrome PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 2: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 8) {
                    return IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)this.mColorData.getIndexColorModel());
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Indexed Color PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 1: 
            case 8: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createFromBufferedImageType(10);
                }
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createFromBufferedImageType(11);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Gray Scale PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 3: {
                ColorSpace cs = this.getEmbeddedColorSpace();
                if (cs == null) {
                    cs = ColorSpace.getInstance(1000);
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 0, true, false);
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 1, false, false);
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 1, true, false);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for RGB PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 4: {
                ColorSpace cs = this.getEmbeddedColorSpace();
                if (cs == null) {
                    cs = CMYKColorSpace.getInstance();
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 0, false, false);
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3, 4}, new int[]{0, 0, 0, 0, 0}, 0, true, false);
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3}, new int[]{0, 0, 0, 0}, 1, false, false);
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createBanded(cs, new int[]{0, 1, 2, 3, 4}, new int[]{0, 0, 0, 0, 0}, 1, true, false);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for CMYK PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
        }
        throw new IIOException(String.format("Unsupported PSD MODE: %s (%d channels/%d bits)", this.mHeader.mMode, this.mHeader.mChannels, this.mHeader.mBits));
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int pIndex) throws IOException {
        ImageTypeSpecifier rawType = this.getRawImageTypeInternal(pIndex);
        ColorSpace cs = rawType.getColorModel().getColorSpace();
        ArrayList<ImageTypeSpecifier> types = new ArrayList<ImageTypeSpecifier>();
        switch (this.mHeader.mMode) {
            case 3: {
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 8) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{2, 1, 0}, 0, false, false));
                    break;
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 8) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{3, 2, 1, 0}, 0, true, false));
                    break;
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 16) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{2, 1, 0}, 1, false, false));
                    break;
                }
                if (this.mHeader.mChannels < 4 || this.mHeader.mBits != 16) break;
                types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{3, 2, 1, 0}, 1, true, false));
                break;
            }
            case 4: {
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 8) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{3, 2, 1, 0}, 0, false, false));
                    break;
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 8) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{4, 3, 2, 1, 0}, 0, true, false));
                    break;
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 16) {
                    types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{3, 2, 1, 0}, 1, false, false));
                    break;
                }
                if (this.mHeader.mChannels != 5 || this.mHeader.mBits != 16) break;
                types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{4, 3, 2, 1, 0}, 1, true, false));
                break;
            }
        }
        types.add(rawType);
        return types.iterator();
    }

    private ColorSpace getEmbeddedColorSpace() throws IOException {
        this.readImageResources(true);
        this.readLayerAndMaskInfo(false);
        if (this.mColorSpace == null) {
            ICC_Profile profile = null;
            for (PSDImageResource resource : this.mImageResources) {
                if (!(resource instanceof ICCProfile)) continue;
                profile = ((ICCProfile)resource).getProfile();
                break;
            }
            this.mColorSpace = profile == null ? null : new ICC_ColorSpace(profile);
        }
        return this.mColorSpace;
    }

    public BufferedImage read(int pIndex, ImageReadParam pParam) throws IOException {
        int xSub;
        int ySub;
        this.checkBounds(pIndex);
        this.readHeader();
        this.readImageResources(false);
        this.readLayerAndMaskInfo(false);
        BufferedImage image = PSDImageReader.getDestination((ImageReadParam)pParam, this.getImageTypes(pIndex), (int)this.mHeader.mWidth, (int)this.mHeader.mHeight);
        ImageTypeSpecifier rawType = this.getRawImageType(pIndex);
        PSDImageReader.checkReadParamBandSettings((ImageReadParam)pParam, (int)rawType.getNumBands(), (int)image.getSampleModel().getNumBands());
        Rectangle source = new Rectangle();
        Rectangle dest = new Rectangle();
        PSDImageReader.computeRegions((ImageReadParam)pParam, (int)this.mHeader.mWidth, (int)this.mHeader.mHeight, (BufferedImage)image, (Rectangle)source, (Rectangle)dest);
        if (pParam == null) {
            ySub = 1;
            xSub = 1;
        } else {
            xSub = pParam.getSourceXSubsampling();
            ySub = pParam.getSourceYSubsampling();
        }
        this.processImageStarted(pIndex);
        int[] offsets = null;
        short compression = this.mImageInput.readShort();
        switch (compression) {
            case 0: {
                break;
            }
            case 1: {
                offsets = new int[this.mHeader.mChannels * this.mHeader.mHeight];
                for (int i = 0; i < offsets.length; ++i) {
                    offsets[i] = this.mImageInput.readUnsignedShort();
                }
                break;
            }
            case 2: 
            case 3: {
                throw new IIOException("ZIP compression not supported yet");
            }
            default: {
                throw new IIOException(String.format("Unknown PSD compression: %d. Expected 0 (none), 1 (RLE), 2 (ZIP) or 3 (ZIP w/prediction).", compression));
            }
        }
        this.readImageData(image, rawType.getColorModel(), source, dest, xSub, ySub, offsets, compression);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return image;
    }

    private void readImageData(BufferedImage pImage, ColorModel pSourceCM, Rectangle pSource, Rectangle pDest, int pXSub, int pYSub, int[] pOffsets, int pCompression) throws IOException {
        WritableRaster raster = pImage.getRaster();
        ColorModel destCM = pImage.getColorModel();
        WritableRaster rowRaster = pSourceCM.createCompatibleWritableRaster(this.mHeader.mWidth, 1);
        int channels = rowRaster.getNumBands();
        boolean banded = raster.getDataBuffer().getNumBanks() > 1;
        int interleavedBands = banded ? 1 : raster.getNumBands();
        for (int c = 0; c < channels; ++c) {
            int bandOffset = banded ? 0 : interleavedBands - 1 - c;
            switch (this.mHeader.mBits) {
                case 1: {
                    byte[] row1 = ((DataBufferByte)rowRaster.getDataBuffer()).getData();
                    DataBufferByte buffer1 = (DataBufferByte)raster.getDataBuffer();
                    byte[] data1 = banded ? buffer1.getData(c) : buffer1.getData();
                    this.read1bitChannel(c, data1, interleavedBands, bandOffset, pSourceCM, row1, pSource, pDest, pXSub, pYSub, pOffsets, pCompression == 1);
                    break;
                }
                case 8: {
                    byte[] row8 = ((DataBufferByte)rowRaster.getDataBuffer()).getData();
                    DataBufferByte buffer8 = (DataBufferByte)raster.getDataBuffer();
                    byte[] data8 = banded ? buffer8.getData(c) : buffer8.getData();
                    this.read8bitChannel(c, data8, interleavedBands, bandOffset, pSourceCM, row8, pSource, pDest, pXSub, pYSub, pOffsets, pCompression == 1);
                    break;
                }
                case 16: {
                    short[] row16 = ((DataBufferUShort)rowRaster.getDataBuffer()).getData();
                    DataBufferUShort buffer16 = (DataBufferUShort)raster.getDataBuffer();
                    short[] data16 = banded ? buffer16.getData(c) : buffer16.getData();
                    this.read16bitChannel(c, data16, interleavedBands, bandOffset, pSourceCM, row16, pSource, pDest, pXSub, pYSub, pOffsets, pCompression == 1);
                    break;
                }
                default: {
                    throw new IIOException("Unknown PSD bit depth: " + this.mHeader.mBits);
                }
            }
            if (this.abortRequested()) break;
        }
        if (this.mHeader.mBits == 8) {
            this.decomposeAlpha(destCM, (DataBufferByte)raster.getDataBuffer(), pDest.width, pDest.height, raster.getNumBands());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read16bitChannel(int pChannel, short[] pData, int pBands, int pBandOffset, ColorModel pSourceColorModel, short[] pRow, Rectangle pSource, Rectangle pDest, int pXSub, int pYSub, int[] pRowOffsets, boolean pRLECompressed) throws IOException {
        boolean isCMYK = pSourceColorModel.getColorSpace().getType() == 9;
        int colorComponents = pSourceColorModel.getColorSpace().getNumComponents();
        for (int y = 0; y < this.mHeader.mHeight; ++y) {
            int length = 2 * (pRLECompressed ? pRowOffsets[pChannel * this.mHeader.mHeight + y] : this.mHeader.mWidth);
            if (y >= pSource.y && y < pSource.y + pSource.height && y % pYSub == 0) {
                int x;
                block9: {
                    if (pRLECompressed) {
                        Object var20_22;
                        DataInputStream input = PSDUtil.createPackBitsStream(this.mImageInput, length);
                        try {
                            for (x = 0; x < this.mHeader.mWidth; ++x) {
                                pRow[x] = input.readShort();
                            }
                            var20_22 = null;
                        }
                        catch (Throwable throwable) {
                            var20_22 = null;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                        {
                            break block9;
                        }
                    }
                    this.mImageInput.readFully(pRow, 0, this.mHeader.mWidth);
                }
                int offset = (y - pSource.y) / pYSub * pDest.width * pBands + pBandOffset;
                for (x = 0; x < pDest.width; ++x) {
                    short value = pRow[pSource.x + x * pXSub];
                    if (isCMYK && pChannel < colorComponents) {
                        value = (short)(65535 - value & 0xFFFF);
                    }
                    pData[offset + x * pBands] = value;
                }
            } else {
                this.mImageInput.skipBytes(length);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(pChannel * y * 100 / this.mHeader.mChannels * this.mHeader.mHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read8bitChannel(int pChannel, byte[] pData, int pBands, int pBandOffset, ColorModel pSourceColorModel, byte[] pRow, Rectangle pSource, Rectangle pDest, int pXSub, int pYSub, int[] pRowOffsets, boolean pRLECompressed) throws IOException {
        boolean isCMYK = pSourceColorModel.getColorSpace().getType() == 9;
        int colorComponents = pSourceColorModel.getColorSpace().getNumComponents();
        for (int y = 0; y < this.mHeader.mHeight; ++y) {
            int length;
            int n = length = pRLECompressed ? pRowOffsets[pChannel * this.mHeader.mHeight + y] : this.mHeader.mWidth;
            if (y >= pSource.y && y < pSource.y + pSource.height && y % pYSub == 0) {
                block8: {
                    if (pRLECompressed) {
                        Object var19_21;
                        DataInputStream input = PSDUtil.createPackBitsStream(this.mImageInput, length);
                        try {
                            input.readFully(pRow, 0, this.mHeader.mWidth);
                            var19_21 = null;
                        }
                        catch (Throwable throwable) {
                            var19_21 = null;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                        {
                            break block8;
                        }
                    }
                    this.mImageInput.readFully(pRow, 0, this.mHeader.mWidth);
                }
                int offset = (y - pSource.y) / pYSub * pDest.width * pBands + pBandOffset;
                for (int x = 0; x < pDest.width; ++x) {
                    byte value = pRow[pSource.x + x * pXSub];
                    if (isCMYK && pChannel < colorComponents) {
                        value = (byte)(255 - value & 0xFF);
                    }
                    pData[offset + x * pBands] = value;
                }
            } else {
                this.mImageInput.skipBytes(length);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(pChannel * y * 100 / this.mHeader.mChannels * this.mHeader.mHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read1bitChannel(int pChannel, byte[] pData, int pBands, int pBandOffset, ColorModel pSourceColorModel, byte[] pRow, Rectangle pSource, Rectangle pDest, int pXSub, int pYSub, int[] pRowOffsets, boolean pRLECompressed) throws IOException {
        int destWidth = (pDest.width + 7) / 8;
        for (int y = 0; y < this.mHeader.mHeight; ++y) {
            int length;
            int n = length = pRLECompressed ? pRowOffsets[y] : this.mHeader.mWidth;
            if (y >= pSource.y && y < pSource.y + pSource.height && y % pYSub == 0) {
                block11: {
                    if (pRLECompressed) {
                        Object var18_20;
                        DataInputStream input = PSDUtil.createPackBitsStream(this.mImageInput, length);
                        try {
                            input.readFully(pRow, 0, pRow.length);
                            var18_20 = null;
                        }
                        catch (Throwable throwable) {
                            var18_20 = null;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                        {
                            break block11;
                        }
                    }
                    this.mImageInput.readFully(pRow, 0, pRow.length);
                }
                int offset = (y - pSource.y) / pYSub * destWidth;
                if (pXSub == 1 && pSource.x % 8 == 0) {
                    for (int i = 0; i < destWidth; ++i) {
                        byte value = pRow[pSource.x / 8 + i * pXSub];
                        pData[offset + i] = (byte)(~value & 0xFF);
                    }
                } else {
                    int maxX = pSource.x + pSource.width;
                    int x = pSource.x;
                    for (int i = 0; i < destWidth; ++i) {
                        int result = 0;
                        for (int j = 0; j < 8 && x < maxX; x += pXSub, ++j) {
                            int bytePos = x / 8;
                            int sourceBitOff = 7 - x % 8;
                            int mask = 1 << sourceBitOff;
                            int destBitOff = 7 - j;
                            result = (byte)(result | (pRow[bytePos] & mask) >> sourceBitOff << destBitOff);
                        }
                        pData[offset + i] = (byte)(~result & 0xFF);
                    }
                }
            } else {
                this.mImageInput.skipBytes(length);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(pChannel * y * 100 / this.mHeader.mChannels * this.mHeader.mHeight);
        }
    }

    private void decomposeAlpha(ColorModel pModel, DataBufferByte pBuffer, int pWidth, int pHeight, int pChannels) {
        block12: {
            if (!pModel.hasAlpha() || pModel.getColorSpace().getType() != 5) break block12;
            if (pBuffer.getNumBanks() > 1) {
                byte[][] data = pBuffer.getBankData();
                for (int y = 0; y < pHeight; ++y) {
                    for (int x = 0; x < pWidth; ++x) {
                        int offset = x + y * pWidth;
                        int alpha = data[pChannels - 1][offset] & 0xFF;
                        if (alpha != 0) {
                            double normalizedAlpha = (double)alpha / 255.0;
                            for (int i = 0; i < pChannels - 1; ++i) {
                                data[i][offset] = PSDImageReader.decompose(data[i][offset] & 0xFF, normalizedAlpha);
                            }
                            continue;
                        }
                        for (int i = 0; i < pChannels - 1; ++i) {
                            data[i][offset] = 0;
                        }
                    }
                }
            } else {
                byte[] data = pBuffer.getData();
                for (int y = 0; y < pHeight; ++y) {
                    for (int x = 0; x < pWidth; ++x) {
                        int offset = (x + y * pWidth) * pChannels;
                        int alpha = data[offset] & 0xFF;
                        if (alpha != 0) {
                            double normalizedAlpha = (double)alpha / 255.0;
                            for (int i = 1; i < pChannels; ++i) {
                                data[offset + i] = PSDImageReader.decompose(data[offset + i] & 0xFF, normalizedAlpha);
                            }
                            continue;
                        }
                        for (int i = 1; i < pChannels; ++i) {
                            data[offset + i] = 0;
                        }
                    }
                }
            }
        }
    }

    private static byte decompose(int pColor, double pAlpha) {
        double color = (double)pColor / 255.0;
        return (byte)((color / pAlpha - (1.0 - pAlpha) / pAlpha) * 255.0);
    }

    public void readHeader() throws IOException {
        this.assertInput();
        if (this.mHeader == null) {
            this.mHeader = new PSDHeader(this.mImageInput);
            if (this.mHeader.mMode == 2) {
                this.mColorData = new PSDColorData(this.mImageInput);
            } else {
                long length = this.mImageInput.readUnsignedInt();
                this.mImageInput.skipBytes(length);
            }
            this.mImageInput.flushBefore(this.mImageInput.getStreamPosition());
        }
    }

    public void readImageResources(boolean pParseData) throws IOException {
        long pos = this.mImageInput.getFlushedPosition();
        this.mImageInput.seek(pos);
        long length = this.mImageInput.readUnsignedInt();
        if (pParseData && length > 0L && this.mImageResources == null) {
            this.mImageResources = new ArrayList<PSDImageResource>();
            long expectedEnd = this.mImageInput.getStreamPosition() + length;
            while (this.mImageInput.getStreamPosition() < expectedEnd) {
                PSDImageResource resource = PSDImageResource.read(this.mImageInput);
                this.mImageResources.add(resource);
            }
            if (this.mImageInput.getStreamPosition() != expectedEnd) {
                throw new IIOException("Corrupt PSD document");
            }
        }
        this.mImageInput.seek(pos + length + 4L);
    }

    public void readLayerAndMaskInfo(boolean pParseData) throws IOException {
        long length = this.mImageInput.readUnsignedInt();
        if (pParseData && length > 0L) {
            long pos = this.mImageInput.getStreamPosition();
            long layerInfoLength = this.mImageInput.readUnsignedInt();
            short layers = this.mImageInput.readShort();
            PSDLayerInfo[] layerInfo = new PSDLayerInfo[Math.abs(layers)];
            for (int i = 0; i < layerInfo.length; ++i) {
                layerInfo[i] = new PSDLayerInfo(this.mImageInput);
            }
            this.mLayerInfo = Arrays.asList(layerInfo);
            for (PSDLayerInfo info : layerInfo) {
                for (PSDChannelInfo channelInfo : info.mChannelInfo) {
                    int compression = this.mImageInput.readUnsignedShort();
                    switch (compression) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new IIOException(String.format("Unknown PSD compression: %d. Expected 0 (none), 1 (RLE), 2 (ZIP) or 3 (ZIP w/prediction).", compression));
                        }
                    }
                    this.mImageInput.skipBytes(channelInfo.mLength - 2L);
                }
            }
            long read = this.mImageInput.getStreamPosition() - pos;
            long diff = layerInfoLength - (read - 4L);
            this.mImageInput.skipBytes(diff);
            long layerMaskInfoLength = this.mImageInput.readUnsignedInt();
            if (layerMaskInfoLength > 0L) {
                this.mGlobalLayerMask = new PSDGlobalLayerMask(this.mImageInput);
            }
            read = this.mImageInput.getStreamPosition() - pos;
            long toSkip = length - read;
            this.mImageInput.skipBytes(toSkip);
        } else {
            this.mImageInput.skipBytes(length);
        }
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    private List<PSDThumbnail> getThumbnailResources(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        ArrayList<PSDThumbnail> thumbnails = null;
        if (this.mImageResources == null) {
            this.readImageResources(true);
            this.readLayerAndMaskInfo(false);
        }
        for (PSDImageResource resource : this.mImageResources) {
            if (!(resource instanceof PSDThumbnail)) continue;
            if (thumbnails == null) {
                thumbnails = new ArrayList<PSDThumbnail>();
            }
            thumbnails.add((PSDThumbnail)resource);
        }
        return thumbnails;
    }

    public int getNumThumbnails(int pIndex) throws IOException {
        List<PSDThumbnail> thumbnails = this.getThumbnailResources(pIndex);
        return thumbnails == null ? 0 : thumbnails.size();
    }

    private PSDThumbnail getThumbnailResource(int pImageIndex, int pThumbnailIndex) throws IOException {
        List<PSDThumbnail> thumbnails = this.getThumbnailResources(pImageIndex);
        if (thumbnails == null) {
            throw new IndexOutOfBoundsException(String.format("thumbnail index %d > 0", pThumbnailIndex));
        }
        return thumbnails.get(pThumbnailIndex);
    }

    public int getThumbnailWidth(int pImageIndex, int pThumbnailIndex) throws IOException {
        return this.getThumbnailResource(pImageIndex, pThumbnailIndex).getWidth();
    }

    public int getThumbnailHeight(int pImageIndex, int pThumbnailIndex) throws IOException {
        return this.getThumbnailResource(pImageIndex, pThumbnailIndex).getHeight();
    }

    public BufferedImage readThumbnail(int pImageIndex, int pThumbnailIndex) throws IOException {
        PSDThumbnail thumbnail = this.getThumbnailResource(pImageIndex, pThumbnailIndex);
        this.processThumbnailStarted(pImageIndex, pThumbnailIndex);
        this.processThumbnailComplete();
        return thumbnail.getThumbnail();
    }

    public static void main(String[] pArgs) throws IOException {
        int subsampleFactor = 1;
        Rectangle sourceRegion = null;
        int idx = 0;
        while (pArgs[idx].charAt(0) == '-') {
            if (pArgs[idx].equals("-s")) {
                subsampleFactor = Integer.parseInt(pArgs[++idx]);
            } else if (pArgs[idx].equals("-r")) {
                int xw = Integer.parseInt(pArgs[++idx]);
                int yh = Integer.parseInt(pArgs[++idx]);
                try {
                    int w = Integer.parseInt(pArgs[idx + 1]);
                    int h = Integer.parseInt(pArgs[idx + 2]);
                    idx += 2;
                    sourceRegion = new Rectangle(xw, yh, w, h);
                }
                catch (NumberFormatException e) {
                    sourceRegion = new Rectangle(xw, yh);
                }
                System.out.println("sourceRegion: " + sourceRegion);
            } else {
                System.err.println("Usage: java PSDImageReader [-s <subsample factor>] [-r [<x y>] <w h>] <image file>");
                System.exit(1);
            }
            ++idx;
        }
        PSDImageReader imageReader = new PSDImageReader(null);
        File file = new File(pArgs[idx]);
        ImageInputStream stream = ImageIO.createImageInputStream(file);
        imageReader.setInput(stream);
        imageReader.readHeader();
        System.out.println("imageReader.mHeader: " + imageReader.mHeader);
        imageReader.readImageResources(true);
        System.out.println("imageReader.mImageResources: " + imageReader.mImageResources);
        imageReader.readLayerAndMaskInfo(true);
        System.out.println("imageReader.mLayerInfo: " + imageReader.mLayerInfo);
        System.out.println("imageReader.mGlobalLayerMask: " + imageReader.mGlobalLayerMask);
        if (imageReader.hasThumbnails(0)) {
            int thumbnails = imageReader.getNumThumbnails(0);
            for (int i = 0; i < thumbnails; ++i) {
                PSDImageReader.showIt((BufferedImage)imageReader.readThumbnail(0, i), (String)String.format("Thumbnail %d", i));
            }
        }
        long start = System.currentTimeMillis();
        ImageReadParam param = imageReader.getDefaultReadParam();
        if (sourceRegion != null) {
            param.setSourceRegion(sourceRegion);
        }
        if (subsampleFactor > 1) {
            param.setSourceSubsampling(subsampleFactor, subsampleFactor, 0, 0);
        }
        BufferedImage image = imageReader.read(0, param);
        System.out.println("time: " + (System.currentTimeMillis() - start));
        System.out.println("image: " + image);
        if (image.getColorModel().getColorSpace().getType() == 9) {
            try {
                ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1000), null);
                image = op.filter(image, new BufferedImage(image.getWidth(), image.getHeight(), 7));
            }
            catch (Exception e) {
                e.printStackTrace();
                image = ImageUtil.accelerate((Image)image);
            }
            System.out.println("time: " + (System.currentTimeMillis() - start));
            System.out.println("image: " + image);
        }
        PSDImageReader.showIt((BufferedImage)image, (String)file.getName());
    }
}

