/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSD;
import com.twelvemonkeys.imageio.plugins.psd.PSDAlphaChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDDisplayInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlags;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlagsInformation;
import com.twelvemonkeys.imageio.plugins.psd.PSDResolutionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.plugins.psd.PSDXMPData;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDImageResource {
    final short mId;
    final String mName;
    final long mSize;

    PSDImageResource(short pId, ImageInputStream pInput) throws IOException {
        this.mId = pId;
        this.mName = PSDUtil.readPascalString(pInput);
        this.mSize = pInput.readUnsignedInt();
        this.readData(pInput);
        if (this.mSize % 2L != 0L) {
            pInput.read();
        }
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        pInput.skipBytes(this.mSize);
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        builder.append(", data length: ");
        builder.append(this.mSize);
        builder.append("]");
        return builder.toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(PSDImageResource.resourceTypeForId(this.mId));
        builder.append("[ID: 0x");
        builder.append(Integer.toHexString(this.mId));
        if (this.mName != null && this.mName.trim().length() != 0) {
            builder.append(", name: \"");
            builder.append(this.mName);
            builder.append("\"");
        }
        return builder;
    }

    static String resourceTypeForId(short pId) {
        switch (pId) {
            case 1005: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1033: 
            case 1036: 
            case 1039: 
            case 1058: 
            case 1060: 
            case 10000: {
                return "";
            }
        }
        try {
            for (Field field : PSD.class.getDeclaredFields()) {
                if (!field.getName().startsWith("RES_") || field.getInt(null) != pId) continue;
                return "(" + field.getName().substring(4) + ")";
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "(unknown resource)";
    }

    public static PSDImageResource read(ImageInputStream pInput) throws IOException {
        int type = pInput.readInt();
        if (type != 943868237) {
            throw new IIOException(String.format("Wrong image resource type, expected '8BIM': '%s'", PSDUtil.intToStr(type)));
        }
        short id = pInput.readShort();
        switch (id) {
            case 1005: {
                return new PSDResolutionInfo(id, pInput);
            }
            case 1006: {
                return new PSDAlphaChannelInfo(id, pInput);
            }
            case 1007: {
                return new PSDDisplayInfo(id, pInput);
            }
            case 1011: {
                return new PSDPrintFlags(id, pInput);
            }
            case 1033: 
            case 1036: {
                return new PSDThumbnail(id, pInput);
            }
            case 1039: {
                return new ICCProfile(id, pInput);
            }
            case 1058: {
                return new PSDEXIF1Data(id, pInput);
            }
            case 1060: {
                return new PSDXMPData(id, pInput);
            }
            case 10000: {
                return new PSDPrintFlagsInformation(id, pInput);
            }
        }
        if (id >= 2000 && id <= 2998) {
            return new PSDImageResource(id, pInput);
        }
        return new PSDImageResource(id, pInput);
    }
}

